/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.functions;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.asterix.common.replication.ReplicaEvent;
import org.apache.asterix.replication.functions.ReplicaFilesRequest;
import org.apache.asterix.replication.functions.ReplicaIndexFlushRequest;
import org.apache.asterix.replication.management.NetworkingUtil;
import org.apache.asterix.replication.storage.LSMComponentProperties;
import org.apache.asterix.replication.storage.LSMIndexFileProperties;
import org.apache.hyracks.data.std.util.ExtendedByteArrayOutputStream;

public class ReplicationProtocol {
    public static final String JOB_REPLICATION_ACK = "$";
    public static final int REPLICATION_REQUEST_TYPE_SIZE = 4;
    public static final int REPLICATION_REQUEST_HEADER_SIZE = 8;

    public static ByteBuffer readRequest(SocketChannel socketChannel, ByteBuffer dataBuffer) throws IOException {
        NetworkingUtil.readBytes(socketChannel, dataBuffer, 4);
        int requestSize = dataBuffer.getInt();
        if (dataBuffer.capacity() < requestSize) {
            dataBuffer = ByteBuffer.allocate(requestSize);
        }
        NetworkingUtil.readBytes(socketChannel, dataBuffer, requestSize);
        return dataBuffer;
    }

    public static ByteBuffer writeLSMComponentPropertiesRequest(LSMComponentProperties lsmCompProp, ByteBuffer buffer) throws IOException {
        ExtendedByteArrayOutputStream outputStream = new ExtendedByteArrayOutputStream();
        try (DataOutputStream oos = new DataOutputStream((OutputStream)outputStream);){
            lsmCompProp.serialize(oos);
            int requestSize = 8 + oos.size();
            if (buffer.capacity() < requestSize) {
                buffer = ByteBuffer.allocate(requestSize);
            } else {
                buffer.clear();
            }
            buffer.putInt(ReplicationRequestType.LSM_COMPONENT_PROPERTIES.ordinal());
            buffer.putInt(oos.size());
            buffer.put(outputStream.getByteArray(), 0, outputStream.getLength());
            buffer.flip();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    public static ReplicationRequestType getRequestType(SocketChannel socketChannel, ByteBuffer byteBuffer) throws IOException {
        NetworkingUtil.readBytes(socketChannel, byteBuffer, 4);
        ReplicationRequestType requestType = ReplicationRequestType.values()[byteBuffer.getInt()];
        return requestType;
    }

    public static LSMComponentProperties readLSMPropertiesRequest(ByteBuffer buffer) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), buffer.limit());
        DataInputStream dis = new DataInputStream(bais);
        return LSMComponentProperties.create(dis);
    }

    public static ByteBuffer getGoodbyeBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(ReplicationRequestType.GOODBYE.ordinal());
        bb.flip();
        return bb;
    }

    public static ByteBuffer getAckBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(ReplicationRequestType.ACK.ordinal());
        bb.flip();
        return bb;
    }

    public static ByteBuffer writeFileReplicationRequest(ByteBuffer requestBuffer, LSMIndexFileProperties afp, ReplicationRequestType requestType) throws IOException {
        ExtendedByteArrayOutputStream outputStream = new ExtendedByteArrayOutputStream();
        try (DataOutputStream oos = new DataOutputStream((OutputStream)outputStream);){
            afp.serialize(oos);
            int requestSize = 8 + oos.size();
            if (requestBuffer.capacity() < requestSize) {
                requestBuffer = ByteBuffer.allocate(requestSize);
            } else {
                requestBuffer.clear();
            }
            requestBuffer.putInt(requestType.ordinal());
            requestBuffer.putInt(oos.size());
            requestBuffer.put(outputStream.getByteArray(), 0, outputStream.getLength());
            requestBuffer.flip();
            ByteBuffer byteBuffer = requestBuffer;
            return byteBuffer;
        }
    }

    public static LSMIndexFileProperties readFileReplicationRequest(ByteBuffer buffer) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), buffer.limit());
        DataInputStream dis = new DataInputStream(bais);
        return LSMIndexFileProperties.create(dis);
    }

    public static ByteBuffer writeReplicaEventRequest(ReplicaEvent event) throws IOException {
        ExtendedByteArrayOutputStream outputStream = new ExtendedByteArrayOutputStream();
        try (DataOutputStream oos = new DataOutputStream((OutputStream)outputStream);){
            event.serialize((OutputStream)oos);
            ByteBuffer buffer = ByteBuffer.allocate(8 + oos.size());
            buffer.putInt(ReplicationRequestType.REPLICA_EVENT.ordinal());
            buffer.putInt(oos.size());
            buffer.put(outputStream.getByteArray(), 0, outputStream.getLength());
            buffer.flip();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    public static ReplicaEvent readReplicaEventRequest(ByteBuffer buffer) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), buffer.limit());
        DataInputStream dis = new DataInputStream(bais);
        return ReplicaEvent.create((DataInput)dis);
    }

    public static ByteBuffer writeGetReplicaFilesRequest(ByteBuffer buffer, ReplicaFilesRequest request) throws IOException {
        ExtendedByteArrayOutputStream outputStream = new ExtendedByteArrayOutputStream();
        try (DataOutputStream oos = new DataOutputStream((OutputStream)outputStream);){
            request.serialize(oos);
            int requestSize = 8 + oos.size();
            if (buffer.capacity() < requestSize) {
                buffer = ByteBuffer.allocate(requestSize);
            } else {
                buffer.clear();
            }
            buffer.putInt(ReplicationRequestType.GET_REPLICA_FILES.ordinal());
            buffer.putInt(oos.size());
            buffer.put(outputStream.getByteArray(), 0, outputStream.getLength());
            buffer.flip();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    public static ByteBuffer writeGetReplicaIndexFlushRequest(ByteBuffer buffer, ReplicaIndexFlushRequest request) throws IOException {
        ExtendedByteArrayOutputStream outputStream = new ExtendedByteArrayOutputStream();
        try (DataOutputStream oos = new DataOutputStream((OutputStream)outputStream);){
            request.serialize(oos);
            int requestSize = 8 + oos.size();
            if (buffer.capacity() < requestSize) {
                buffer = ByteBuffer.allocate(requestSize);
            } else {
                buffer.clear();
            }
            buffer.putInt(ReplicationRequestType.FLUSH_INDEX.ordinal());
            buffer.putInt(oos.size());
            buffer.put(outputStream.getByteArray(), 0, outputStream.getLength());
            buffer.flip();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    public static ReplicaFilesRequest readReplicaFileRequest(ByteBuffer buffer) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), buffer.limit());
        DataInputStream dis = new DataInputStream(bais);
        return ReplicaFilesRequest.create(dis);
    }

    public static ReplicaIndexFlushRequest readReplicaIndexFlushRequest(ByteBuffer buffer) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer.array(), buffer.position(), buffer.limit());
        DataInputStream dis = new DataInputStream(bais);
        return ReplicaIndexFlushRequest.create(dis);
    }

    public static void writeGetReplicaMaxLSNRequest(ByteBuffer requestBuffer) {
        requestBuffer.clear();
        requestBuffer.putInt(ReplicationRequestType.GET_REPLICA_MAX_LSN.ordinal());
        requestBuffer.flip();
    }

    public static int getJobIdFromLogAckMessage(String msg) {
        return Integer.parseInt(msg.substring(msg.indexOf(JOB_REPLICATION_ACK) + 1));
    }

    public static String getNodeIdFromLogAckMessage(String msg) {
        return msg.substring(0, msg.indexOf(JOB_REPLICATION_ACK));
    }

    public static void sendGoodbye(SocketChannel socketChannel) throws IOException {
        ByteBuffer goodbyeBuffer = ReplicationProtocol.getGoodbyeBuffer();
        NetworkingUtil.transferBufferToChannel(socketChannel, goodbyeBuffer);
    }

    public static void sendAck(SocketChannel socketChannel) throws IOException {
        ByteBuffer ackBuffer = ReplicationProtocol.getAckBuffer();
        NetworkingUtil.transferBufferToChannel(socketChannel, ackBuffer);
    }

    public static enum ReplicationRequestType {
        REPLICATE_LOG,
        REPLICATE_FILE,
        DELETE_FILE,
        GET_REPLICA_FILES,
        GET_REPLICA_MAX_LSN,
        GOODBYE,
        REPLICA_EVENT,
        LSM_COMPONENT_PROPERTIES,
        ACK,
        FLUSH_INDEX;

    }
}

