/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.functions;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class ReplicaFilesRequest {
    private final Set<Integer> partitionIds;
    private final Set<String> existingFiles;

    public ReplicaFilesRequest(Set<Integer> partitionIds, Set<String> existingFiles) {
        this.partitionIds = partitionIds;
        this.existingFiles = existingFiles;
    }

    public void serialize(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeInt(this.partitionIds.size());
        for (Integer partitionId : this.partitionIds) {
            dos.writeInt(partitionId);
        }
        dos.writeInt(this.existingFiles.size());
        for (String fileName : this.existingFiles) {
            dos.writeUTF(fileName);
        }
    }

    public static ReplicaFilesRequest create(DataInput input) throws IOException {
        int size = input.readInt();
        HashSet<Integer> partitionIds = new HashSet<Integer>(size);
        for (int i = 0; i < size; ++i) {
            partitionIds.add(input.readInt());
        }
        int filesCount = input.readInt();
        HashSet<String> existingFiles = new HashSet<String>(filesCount);
        for (int i = 0; i < filesCount; ++i) {
            existingFiles.add(input.readUTF());
        }
        return new ReplicaFilesRequest(partitionIds, existingFiles);
    }

    public Set<Integer> getPartitionIds() {
        return this.partitionIds;
    }

    public Set<String> getExistingFiles() {
        return this.existingFiles;
    }
}

