/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.util;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;

public class ReferenceEntry {
    private final int runid;
    private IFrameTupleAccessor acccessor;
    private int tupleIndex;
    private int[] tPointers;

    public ReferenceEntry(int runid, FrameTupleAccessor fta, int tupleIndex, int[] keyFields, INormalizedKeyComputer nmkComputer) {
        this.runid = runid;
        this.acccessor = fta;
        this.tPointers = new int[1 + 2 * keyFields.length];
        if (fta != null) {
            this.initTPointer((IFrameTupleAccessor)fta, tupleIndex, keyFields, nmkComputer);
        }
    }

    public int getRunid() {
        return this.runid;
    }

    public IFrameTupleAccessor getAccessor() {
        return this.acccessor;
    }

    public void setAccessor(IFrameTupleAccessor fta) {
        this.acccessor = fta;
    }

    public int[] getTPointers() {
        return this.tPointers;
    }

    public int getTupleIndex() {
        return this.tupleIndex;
    }

    public int getNormalizedKey() {
        return this.tPointers[0];
    }

    public void setTupleIndex(int tupleIndex, int[] keyFields, INormalizedKeyComputer nmkComputer) {
        this.initTPointer(this.acccessor, tupleIndex, keyFields, nmkComputer);
    }

    private void initTPointer(IFrameTupleAccessor fta, int tupleIndex, int[] keyFields, INormalizedKeyComputer nmkComputer) {
        this.tupleIndex = tupleIndex;
        byte[] b1 = fta.getBuffer().array();
        for (int f = 0; f < keyFields.length; ++f) {
            int fIdx = keyFields[f];
            this.tPointers[2 * f + 1] = fta.getAbsoluteFieldStartOffset(tupleIndex, fIdx);
            this.tPointers[2 * f + 2] = fta.getFieldLength(tupleIndex, fIdx);
            if (f != 0) continue;
            this.tPointers[0] = nmkComputer != null ? nmkComputer.normalize(b1, this.tPointers[1], this.tPointers[2]) : 0;
        }
    }
}

