/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import org.apache.hyracks.dataflow.std.buffermanager.EnumFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.buffermanager.FrameFreeSlotPolicyFactory;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFrameMemoryManager;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFramePool;
import org.apache.hyracks.dataflow.std.sort.FrameSorterMergeSort;

public class InMemorySortOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private static final int SORT_ACTIVITY_ID = 0;
    private static final int MERGE_ACTIVITY_ID = 1;
    private final int[] sortFields;
    private INormalizedKeyComputerFactory firstKeyNormalizerFactory;
    private IBinaryComparatorFactory[] comparatorFactories;

    public InMemorySortOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] sortFields, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        this(spec, sortFields, null, comparatorFactories, recordDescriptor);
    }

    public InMemorySortOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        super(spec, 1, 1);
        this.sortFields = sortFields;
        this.firstKeyNormalizerFactory = firstKeyNormalizerFactory;
        this.comparatorFactories = comparatorFactories;
        this.outRecDescs[0] = recordDescriptor;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        SortActivity sa = new SortActivity(new ActivityId(this.odId, 0));
        MergeActivity ma = new MergeActivity(new ActivityId(this.odId, 1));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)sa);
        builder.addSourceEdge(0, (IActivity)sa, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)ma);
        builder.addTargetEdge(0, (IActivity)ma, 0);
        builder.addBlockingEdge((IActivity)sa, (IActivity)ma);
    }

    private class MergeActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public MergeActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryOutputSourceOperatorNodePushable op = new AbstractUnaryOutputSourceOperatorNodePushable(){

                @Override
                public void initialize() throws HyracksDataException {
                    try {
                        this.writer.open();
                        SortTaskState state = (SortTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(InMemorySortOperatorDescriptor.this.getOperatorId(), 0), partition));
                        state.frameSorter.flush(this.writer);
                    }
                    catch (Throwable th) {
                        this.writer.fail();
                        throw new HyracksDataException(th);
                    }
                    finally {
                        this.writer.close();
                    }
                }
            };
            return op;
        }
    }

    private class SortActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public SortActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryInputSinkOperatorNodePushable op = new AbstractUnaryInputSinkOperatorNodePushable(){
                private SortTaskState state;

                public void open() throws HyracksDataException {
                    this.state = new SortTaskState(ctx.getJobletContext().getJobId(), new TaskId(SortActivity.this.getActivityId(), partition));
                    VariableFrameMemoryManager frameBufferManager = new VariableFrameMemoryManager(new VariableFramePool((IHyracksFrameMgrContext)ctx, -1), FrameFreeSlotPolicyFactory.createFreeSlotPolicy(EnumFreeSlotPolicy.LAST_FIT));
                    this.state.frameSorter = new FrameSorterMergeSort(ctx, frameBufferManager, InMemorySortOperatorDescriptor.this.sortFields, InMemorySortOperatorDescriptor.this.firstKeyNormalizerFactory, InMemorySortOperatorDescriptor.this.comparatorFactories, InMemorySortOperatorDescriptor.this.outRecDescs[0]);
                    this.state.frameSorter.reset();
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    if (!this.state.frameSorter.insertFrame(buffer)) {
                        throw new HyracksDataException("Failed to insert the given frame into sorting buffer. Please increase the sorting memory budget to enable the in-memory sorting, or you could use ExternalSort instead.");
                    }
                }

                public void close() throws HyracksDataException {
                    this.state.frameSorter.sort();
                    ctx.setStateObject((IStateObject)this.state);
                }

                public void fail() throws HyracksDataException {
                }
            };
            return op;
        }
    }

    private static class SortTaskState
    extends AbstractStateObject {
        private FrameSorterMergeSort frameSorter;

        private SortTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        @Override
        public void toBytes(DataOutput out) throws IOException {
        }

        @Override
        public void fromBytes(DataInput in) throws IOException {
        }
    }
}

