/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.join;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluator;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFactory;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.dataflow.std.buffermanager.DeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.FramePoolBackedFrameBufferManager;
import org.apache.hyracks.dataflow.std.join.InMemoryHashJoin;
import org.apache.hyracks.dataflow.std.structures.SerializableHashTable;
import org.apache.hyracks.dataflow.std.util.FrameTuplePairComparator;

public class InMemoryHashJoinOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final int[] keys0;
    private final int[] keys1;
    private final IBinaryHashFunctionFactory[] hashFunctionFactories;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IPredicateEvaluatorFactory predEvaluatorFactory;
    private final boolean isLeftOuter;
    private final IMissingWriterFactory[] nonMatchWriterFactories;
    private final int tableSize;
    private final int memSizeInFrames;

    public InMemoryHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, int tableSize, IPredicateEvaluatorFactory predEvalFactory, int memSizeInFrames) {
        super(spec, 2, 1);
        this.keys0 = keys0;
        this.keys1 = keys1;
        this.hashFunctionFactories = hashFunctionFactories;
        this.comparatorFactories = comparatorFactories;
        this.predEvaluatorFactory = predEvalFactory;
        this.outRecDescs[0] = recordDescriptor;
        this.isLeftOuter = false;
        this.nonMatchWriterFactories = null;
        this.tableSize = tableSize;
        this.memSizeInFrames = memSizeInFrames;
    }

    public InMemoryHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, IPredicateEvaluatorFactory predEvalFactory, RecordDescriptor recordDescriptor, boolean isLeftOuter, IMissingWriterFactory[] missingWriterFactories1, int tableSize, int memSizeInFrames) {
        super(spec, 2, 1);
        this.keys0 = keys0;
        this.keys1 = keys1;
        this.hashFunctionFactories = hashFunctionFactories;
        this.comparatorFactories = comparatorFactories;
        this.predEvaluatorFactory = predEvalFactory;
        this.outRecDescs[0] = recordDescriptor;
        this.isLeftOuter = isLeftOuter;
        this.nonMatchWriterFactories = missingWriterFactories1;
        this.tableSize = tableSize;
        this.memSizeInFrames = memSizeInFrames;
    }

    public InMemoryHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, int tableSize, int memSizeInFrames) {
        this(spec, keys0, keys1, hashFunctionFactories, comparatorFactories, recordDescriptor, tableSize, null, memSizeInFrames);
    }

    public InMemoryHashJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, int[] keys0, int[] keys1, IBinaryHashFunctionFactory[] hashFunctionFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, boolean isLeftOuter, IMissingWriterFactory[] nullWriterFactories1, int tableSize, int memSizeInFrames) {
        this(spec, keys0, keys1, hashFunctionFactories, comparatorFactories, null, recordDescriptor, isLeftOuter, nullWriterFactories1, tableSize, memSizeInFrames);
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        ActivityId hbaId = new ActivityId(this.odId, 0);
        ActivityId hpaId = new ActivityId(this.odId, 1);
        HashBuildActivityNode hba = new HashBuildActivityNode(hbaId, hpaId);
        HashProbeActivityNode hpa = new HashProbeActivityNode(hpaId);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)hba);
        builder.addSourceEdge(1, (IActivity)hba, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)hpa);
        builder.addSourceEdge(0, (IActivity)hpa, 0);
        builder.addTargetEdge(0, (IActivity)hpa, 0);
        builder.addBlockingEdge((IActivity)hba, (IActivity)hpa);
    }

    private class HashProbeActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public HashProbeActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            AbstractUnaryInputUnaryOutputOperatorNodePushable op = new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
                private HashBuildTaskState state;

                public void open() throws HyracksDataException {
                    this.writer.open();
                    this.state = (HashBuildTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(InMemoryHashJoinOperatorDescriptor.this.getOperatorId(), 0), partition));
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.joiner.join(buffer, this.writer);
                }

                public void close() throws HyracksDataException {
                    try {
                        this.state.joiner.completeJoin(this.writer);
                    }
                    finally {
                        try {
                            this.state.joiner.releaseMemory();
                        }
                        finally {
                            this.writer.close();
                        }
                    }
                }

                public void fail() throws HyracksDataException {
                    this.writer.fail();
                }
            };
            return op;
        }
    }

    private class HashBuildActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId hpaId;

        public HashBuildActivityNode(ActivityId id, ActivityId hpaId) {
            super(id);
            this.hpaId = hpaId;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            IMissingWriter[] nullWriters1;
            final RecordDescriptor rd0 = recordDescProvider.getInputRecordDescriptor(this.hpaId, 0);
            final RecordDescriptor rd1 = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            final IBinaryComparator[] comparators = new IBinaryComparator[InMemoryHashJoinOperatorDescriptor.this.comparatorFactories.length];
            for (int i = 0; i < InMemoryHashJoinOperatorDescriptor.this.comparatorFactories.length; ++i) {
                comparators[i] = InMemoryHashJoinOperatorDescriptor.this.comparatorFactories[i].createBinaryComparator();
            }
            IMissingWriter[] iMissingWriterArray = nullWriters1 = InMemoryHashJoinOperatorDescriptor.this.isLeftOuter ? new IMissingWriter[InMemoryHashJoinOperatorDescriptor.this.nonMatchWriterFactories.length] : null;
            if (InMemoryHashJoinOperatorDescriptor.this.isLeftOuter) {
                for (int i = 0; i < InMemoryHashJoinOperatorDescriptor.this.nonMatchWriterFactories.length; ++i) {
                    nullWriters1[i] = InMemoryHashJoinOperatorDescriptor.this.nonMatchWriterFactories[i].createMissingWriter();
                }
            }
            final IPredicateEvaluator predEvaluator = InMemoryHashJoinOperatorDescriptor.this.predEvaluatorFactory == null ? null : InMemoryHashJoinOperatorDescriptor.this.predEvaluatorFactory.createPredicateEvaluator();
            int memSizeInBytes = InMemoryHashJoinOperatorDescriptor.this.memSizeInFrames * ctx.getInitialFrameSize();
            DeallocatableFramePool framePool = new DeallocatableFramePool((IHyracksFrameMgrContext)ctx, memSizeInBytes);
            final FramePoolBackedFrameBufferManager bufferManager = new FramePoolBackedFrameBufferManager(framePool);
            AbstractUnaryInputSinkOperatorNodePushable op = new AbstractUnaryInputSinkOperatorNodePushable(){
                private HashBuildTaskState state;

                public void open() throws HyracksDataException {
                    ITuplePartitionComputer hpc0 = new FieldHashPartitionComputerFactory(InMemoryHashJoinOperatorDescriptor.this.keys0, InMemoryHashJoinOperatorDescriptor.this.hashFunctionFactories).createPartitioner();
                    ITuplePartitionComputer hpc1 = new FieldHashPartitionComputerFactory(InMemoryHashJoinOperatorDescriptor.this.keys1, InMemoryHashJoinOperatorDescriptor.this.hashFunctionFactories).createPartitioner();
                    this.state = new HashBuildTaskState(ctx.getJobletContext().getJobId(), new TaskId(HashBuildActivityNode.this.getActivityId(), partition));
                    SerializableHashTable table = new SerializableHashTable(InMemoryHashJoinOperatorDescriptor.this.tableSize, (IHyracksFrameMgrContext)ctx, bufferManager);
                    this.state.joiner = new InMemoryHashJoin(ctx, InMemoryHashJoinOperatorDescriptor.this.tableSize, new FrameTupleAccessor(rd0), hpc0, new FrameTupleAccessor(rd1), rd1, hpc1, new FrameTuplePairComparator(InMemoryHashJoinOperatorDescriptor.this.keys0, InMemoryHashJoinOperatorDescriptor.this.keys1, comparators), InMemoryHashJoinOperatorDescriptor.this.isLeftOuter, nullWriters1, table, predEvaluator, bufferManager);
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    ByteBuffer copyBuffer = this.allocateBuffer(buffer.capacity());
                    FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)copyBuffer);
                    this.state.joiner.build(copyBuffer);
                }

                private ByteBuffer allocateBuffer(int frameSize) throws HyracksDataException {
                    ByteBuffer newBuffer = bufferManager.acquireFrame(frameSize);
                    if (newBuffer != null) {
                        return newBuffer;
                    }
                    if (this.state.joiner.compactHashTable() > 0 && (newBuffer = bufferManager.acquireFrame(frameSize)) != null) {
                        return newBuffer;
                    }
                    throw new HyracksDataException("Can't allocate one more frame. Assign more memory to InMemoryHashJoin.");
                }

                public void close() throws HyracksDataException {
                    ctx.setStateObject((IStateObject)this.state);
                }

                public void fail() throws HyracksDataException {
                }
            };
            return op;
        }
    }

    public static class HashBuildTaskState
    extends AbstractStateObject {
        private InMemoryHashJoin joiner;

        public HashBuildTaskState() {
        }

        private HashBuildTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        @Override
        public void toBytes(DataOutput out) throws IOException {
        }

        @Override
        public void fromBytes(DataInput in) throws IOException {
        }
    }
}

