/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.connectors;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.IPartitionCollector;
import org.apache.hyracks.api.comm.IPartitionWriterFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractMToNConnectorDescriptor;
import org.apache.hyracks.dataflow.std.collectors.NonDeterministicChannelReader;
import org.apache.hyracks.dataflow.std.collectors.NonDeterministicFrameReader;
import org.apache.hyracks.dataflow.std.collectors.PartitionCollector;

public class MToNBroadcastConnectorDescriptor
extends AbstractMToNConnectorDescriptor {
    private static final long serialVersionUID = 1L;

    public MToNBroadcastConnectorDescriptor(IConnectorDescriptorRegistry spec) {
        super(spec);
    }

    public IFrameWriter createPartitioner(IHyracksTaskContext ctx, RecordDescriptor recordDesc, IPartitionWriterFactory edwFactory, int index, int nProducerPartitions, int nConsumerPartitions) throws HyracksDataException {
        final IFrameWriter[] epWriters = new IFrameWriter[nConsumerPartitions];
        final boolean[] isOpen = new boolean[nConsumerPartitions];
        for (int i = 0; i < nConsumerPartitions; ++i) {
            epWriters[i] = edwFactory.createFrameWriter(i);
        }
        return new IFrameWriter(){

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                int pos = buffer.position();
                for (int i = 0; i < epWriters.length; ++i) {
                    if (i != 0) {
                        buffer.position(pos);
                    }
                    epWriters[i].nextFrame(buffer);
                }
            }

            public void fail() throws HyracksDataException {
                HyracksDataException failException = null;
                for (int i = 0; i < epWriters.length; ++i) {
                    if (!isOpen[i]) continue;
                    try {
                        epWriters[i].fail();
                        continue;
                    }
                    catch (Throwable th) {
                        if (failException == null) {
                            failException = new HyracksDataException(th);
                            continue;
                        }
                        failException.addSuppressed(th);
                    }
                }
                if (failException != null) {
                    throw failException;
                }
            }

            public void close() throws HyracksDataException {
                HyracksDataException closeException = null;
                for (int i = 0; i < epWriters.length; ++i) {
                    if (!isOpen[i]) continue;
                    try {
                        epWriters[i].close();
                        continue;
                    }
                    catch (Throwable th) {
                        if (closeException == null) {
                            closeException = new HyracksDataException(th);
                            continue;
                        }
                        closeException.addSuppressed(th);
                    }
                }
                if (closeException != null) {
                    throw closeException;
                }
            }

            public void open() throws HyracksDataException {
                for (int i = 0; i < epWriters.length; ++i) {
                    isOpen[i] = true;
                    epWriters[i].open();
                }
            }

            public void flush() throws HyracksDataException {
                for (IFrameWriter writer : epWriters) {
                    writer.flush();
                }
            }
        };
    }

    public IPartitionCollector createPartitionCollector(IHyracksTaskContext ctx, RecordDescriptor recordDesc, int index, int nProducerPartitions, int nConsumerPartitions) throws HyracksDataException {
        BitSet expectedPartitions = new BitSet(nProducerPartitions);
        expectedPartitions.set(0, nProducerPartitions);
        NonDeterministicChannelReader channelReader = new NonDeterministicChannelReader(nProducerPartitions, expectedPartitions);
        NonDeterministicFrameReader frameReader = new NonDeterministicFrameReader(channelReader);
        return new PartitionCollector(ctx, this.getConnectorId(), index, expectedPartitions, frameReader, channelReader);
    }
}

