/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.util.Arrays;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameFreeSlotPolicy;

class FrameFreeSlotLastFit
implements IFrameFreeSlotPolicy {
    private static int INITIAL_CAPACITY = 10;
    private FrameSpace[] frameSpaces;
    private int size;

    public FrameFreeSlotLastFit(int initialFrameNumber) {
        this.frameSpaces = new FrameSpace[initialFrameNumber];
        this.size = 0;
    }

    public FrameFreeSlotLastFit() {
        this(INITIAL_CAPACITY);
    }

    @Override
    public int popBestFit(int tobeInsertedSize) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.frameSpaces[i].freeSpace < tobeInsertedSize) continue;
            FrameSpace ret = this.frameSpaces[i];
            System.arraycopy(this.frameSpaces, i + 1, this.frameSpaces, i, this.size - i - 1);
            this.frameSpaces[--this.size] = ret;
            return ret.frameId;
        }
        return -1;
    }

    @Override
    public void pushNewFrame(int frameID, int freeSpace) {
        if (this.size >= this.frameSpaces.length) {
            this.frameSpaces = Arrays.copyOf(this.frameSpaces, this.size * 2);
        }
        if (this.frameSpaces[this.size] == null) {
            this.frameSpaces[this.size++] = new FrameSpace(frameID, freeSpace);
        } else {
            this.frameSpaces[this.size++].reset(frameID, freeSpace);
        }
    }

    @Override
    public void reset() {
        this.size = 0;
        for (int i = this.frameSpaces.length - 1; i >= 0; --i) {
            this.frameSpaces[i] = null;
        }
    }

    private class FrameSpace {
        private int frameId;
        private int freeSpace;

        FrameSpace(int frameId, int freeSpace) {
            this.reset(frameId, freeSpace);
        }

        void reset(int frameId, int freeSpace) {
            this.frameId = frameId;
            this.freeSpace = freeSpace;
        }
    }
}

