/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.dataflow;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexSearchOperatorNodePushable;
import org.apache.hyracks.storage.am.common.tuples.PermutingFrameTupleReference;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.am.rtree.util.RTreeUtils;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class RTreeSearchOperatorNodePushable
extends IndexSearchOperatorNodePushable {
    protected PermutingFrameTupleReference searchKey;
    protected MultiComparator cmp;

    public RTreeSearchOperatorNodePushable(IHyracksTaskContext ctx, int partition, RecordDescriptor inputRecDesc, int[] keyFields, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, IIndexDataflowHelperFactory indexHelperFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory missingWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, boolean appendIndexFilter) throws HyracksDataException {
        super(ctx, inputRecDesc, partition, minFilterFieldIndexes, maxFilterFieldIndexes, indexHelperFactory, retainInput, retainMissing, missingWriterFactory, searchCallbackFactory, appendIndexFilter);
        if (keyFields != null && keyFields.length > 0) {
            this.searchKey = new PermutingFrameTupleReference();
            this.searchKey.setFieldPermutation(keyFields);
        }
    }

    protected ISearchPredicate createSearchPredicate() {
        ITreeIndex treeIndex = (ITreeIndex)this.index;
        this.cmp = RTreeUtils.getSearchMultiComparator(treeIndex.getComparatorFactories(), (ITupleReference)this.searchKey);
        return new SearchPredicate((ITupleReference)this.searchKey, this.cmp, (ITupleReference)this.minFilterKey, (ITupleReference)this.maxFilterKey);
    }

    protected void resetSearchPredicate(int tupleIndex) {
        if (this.searchKey != null) {
            this.searchKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
        if (this.minFilterKey != null) {
            this.minFilterKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
        if (this.maxFilterKey != null) {
            this.maxFilterKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
    }

    protected int getFieldCount() {
        return ((ITreeIndex)this.index).getFieldCount();
    }
}

