/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.dataflow;

import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.am.rtree.util.RTreeUtils;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IStorageManager;

public class RTreeResource
implements IResource {
    private static final long serialVersionUID = 1L;
    private final String path;
    private final IStorageManager storageManager;
    private final ITypeTraits[] typeTraits;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IPageManagerFactory pageManagerFactory;
    private final IPrimitiveValueProviderFactory[] valueProviderFactories;
    private final RTreePolicyType rtreePolicyType;

    public RTreeResource(String path, IStorageManager storageManager, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] comparatorFactories, IPageManagerFactory pageManagerFactory, IPrimitiveValueProviderFactory[] valueProviderFactories, RTreePolicyType rtreePolicyType) {
        this.path = path;
        this.storageManager = storageManager;
        this.typeTraits = typeTraits;
        this.comparatorFactories = comparatorFactories;
        this.pageManagerFactory = pageManagerFactory;
        this.valueProviderFactories = valueProviderFactories;
        this.rtreePolicyType = rtreePolicyType;
    }

    public IIndex createInstance(INCServiceContext ctx) throws HyracksDataException {
        IIOManager ioManager = ctx.getIoManager();
        FileReference resourceRef = ioManager.resolve(this.path);
        return RTreeUtils.createRTree(this.storageManager.getBufferCache(ctx), this.typeTraits, this.valueProviderFactories, this.comparatorFactories, this.rtreePolicyType, resourceRef, false, this.pageManagerFactory);
    }

    public String getPath() {
        return this.path;
    }
}

