/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IPrefixSlotManager;
import org.apache.hyracks.storage.am.btree.frames.BTreeFieldPrefixNSMLeafFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleMode;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import org.apache.hyracks.storage.common.MultiComparator;

public class FieldPrefixSlotManager
implements IPrefixSlotManager {
    public static final int TUPLE_UNCOMPRESSED = 255;
    public static final int MAX_PREFIX_SLOTS = 254;
    public static final int GREATEST_KEY_INDICATOR = 0xFFFFFF;
    public static final int ERROR_INDICATOR = 0xFFFFFE;
    private static final int slotSize = 4;
    private ByteBuffer buf;
    private BTreeFieldPrefixNSMLeafFrame frame;
    private MultiComparator cmp;

    @Override
    public int decodeFirstSlotField(int slot) {
        return (slot & 0xFF000000) >>> 24;
    }

    @Override
    public int decodeSecondSlotField(int slot) {
        return slot & 0xFFFFFF;
    }

    @Override
    public int encodeSlotFields(int firstField, int secondField) {
        return (firstField & 0xFF) << 24 | secondField & 0xFFFFFF;
    }

    @Override
    public int findPrefix(ITupleReference tuple, ITreeIndexTupleReference framePrefixTuple) throws HyracksDataException {
        int prefixBegin = 0;
        int prefixEnd = this.frame.getPrefixTupleCount() - 1;
        if (this.frame.getPrefixTupleCount() > 0) {
            while (prefixBegin <= prefixEnd) {
                int prefixMid = (prefixBegin + prefixEnd) / 2;
                framePrefixTuple.resetByTupleIndex((ITreeIndexFrame)this.frame, prefixMid);
                int cmpVal = this.cmp.fieldRangeCompare(tuple, (ITupleReference)framePrefixTuple, 0, framePrefixTuple.getFieldCount());
                if (cmpVal < 0) {
                    prefixEnd = prefixMid - 1;
                    continue;
                }
                if (cmpVal > 0) {
                    prefixBegin = prefixMid + 1;
                    continue;
                }
                return prefixMid;
            }
        }
        return 255;
    }

    @Override
    public int findSlot(ITupleReference searchKey, ITreeIndexTupleReference frameTuple, ITreeIndexTupleReference framePrefixTuple, MultiComparator multiCmp, FindTupleMode mode, FindTupleNoExactMatchPolicy matchPolicy) throws HyracksDataException {
        if (this.frame.getTupleCount() <= 0) {
            this.encodeSlotFields(255, 0xFFFFFF);
        }
        int prefixBegin = 0;
        int prefixEnd = this.frame.getPrefixTupleCount() - 1;
        int prefixMatch = 255;
        int tuplePrefixSlotNumLbound = prefixBegin;
        int tuplePrefixSlotNumUbound = prefixEnd;
        while (prefixBegin <= prefixEnd) {
            int prefixMid = (prefixBegin + prefixEnd) / 2;
            framePrefixTuple.resetByTupleIndex((ITreeIndexFrame)this.frame, prefixMid);
            int cmp = multiCmp.fieldRangeCompare(searchKey, (ITupleReference)framePrefixTuple, 0, framePrefixTuple.getFieldCount());
            if (cmp < 0) {
                prefixEnd = prefixMid - 1;
                tuplePrefixSlotNumLbound = prefixMid - 1;
                continue;
            }
            if (cmp > 0) {
                prefixBegin = prefixMid + 1;
                tuplePrefixSlotNumUbound = prefixMid + 1;
                continue;
            }
            if (mode == FindTupleMode.EXCLUSIVE) {
                if (matchPolicy == FindTupleNoExactMatchPolicy.HIGHER_KEY) {
                    prefixBegin = prefixMid + 1;
                    break;
                }
                prefixEnd = prefixMid - 1;
                break;
            }
            tuplePrefixSlotNumLbound = prefixMid;
            tuplePrefixSlotNumUbound = prefixMid;
            prefixMatch = prefixMid;
            break;
        }
        int tupleMid = -1;
        int tupleBegin = 0;
        int tupleEnd = this.frame.getTupleCount() - 1;
        while (tupleBegin <= tupleEnd) {
            tupleMid = (tupleBegin + tupleEnd) / 2;
            int tupleSlotOff = this.getTupleSlotOff(tupleMid);
            int tupleSlot = this.buf.getInt(tupleSlotOff);
            int prefixSlotNum = this.decodeFirstSlotField(tupleSlot);
            int cmp = 0;
            if (prefixSlotNum == 255) {
                frameTuple.resetByTupleIndex((ITreeIndexFrame)this.frame, tupleMid);
                cmp = multiCmp.compare(searchKey, (ITupleReference)frameTuple);
            } else if (prefixSlotNum < tuplePrefixSlotNumLbound) {
                cmp = 1;
            } else if (prefixSlotNum > tuplePrefixSlotNumUbound) {
                cmp = -1;
            } else {
                frameTuple.resetByTupleIndex((ITreeIndexFrame)this.frame, tupleMid);
                cmp = multiCmp.compare(searchKey, (ITupleReference)frameTuple);
            }
            if (cmp < 0) {
                tupleEnd = tupleMid - 1;
                continue;
            }
            if (cmp > 0) {
                tupleBegin = tupleMid + 1;
                continue;
            }
            if (mode == FindTupleMode.EXCLUSIVE) {
                if (matchPolicy == FindTupleNoExactMatchPolicy.HIGHER_KEY) {
                    tupleBegin = tupleMid + 1;
                    continue;
                }
                tupleEnd = tupleMid - 1;
                continue;
            }
            if (mode == FindTupleMode.EXCLUSIVE_ERROR_IF_EXISTS) {
                return this.encodeSlotFields(prefixMatch, 0xFFFFFE);
            }
            return this.encodeSlotFields(prefixMatch, tupleMid);
        }
        if (mode == FindTupleMode.EXACT) {
            return this.encodeSlotFields(prefixMatch, 0xFFFFFE);
        }
        if (matchPolicy == FindTupleNoExactMatchPolicy.HIGHER_KEY) {
            if (tupleBegin > this.frame.getTupleCount() - 1) {
                return this.encodeSlotFields(prefixMatch, 0xFFFFFF);
            }
            frameTuple.resetByTupleIndex((ITreeIndexFrame)this.frame, tupleBegin);
            if (multiCmp.compare(searchKey, (ITupleReference)frameTuple) < 0) {
                return this.encodeSlotFields(prefixMatch, tupleBegin);
            }
            return this.encodeSlotFields(prefixMatch, 0xFFFFFF);
        }
        if (tupleEnd < 0) {
            return this.encodeSlotFields(prefixMatch, 0xFFFFFF);
        }
        frameTuple.resetByTupleIndex((ITreeIndexFrame)this.frame, tupleEnd);
        if (multiCmp.compare(searchKey, (ITupleReference)frameTuple) > 0) {
            return this.encodeSlotFields(prefixMatch, tupleEnd);
        }
        return this.encodeSlotFields(prefixMatch, 0xFFFFFF);
    }

    @Override
    public int getPrefixSlotStartOff() {
        return this.buf.capacity() - 4;
    }

    @Override
    public int getPrefixSlotEndOff() {
        return this.buf.capacity() - 4 * this.frame.getPrefixTupleCount();
    }

    @Override
    public int getTupleSlotStartOff() {
        return this.getPrefixSlotEndOff() - 4;
    }

    @Override
    public int getTupleSlotEndOff() {
        return this.buf.capacity() - 4 * (this.frame.getPrefixTupleCount() + this.frame.getTupleCount());
    }

    @Override
    public int getSlotSize() {
        return 4;
    }

    @Override
    public void setSlot(int offset, int value) {
        this.frame.getBuffer().putInt(offset, value);
    }

    @Override
    public int insertSlot(int slot, int tupleOff) {
        int slotNum = this.decodeSecondSlotField(slot);
        if (slotNum == 0xFFFFFE) {
            System.out.println("WOW BIG PROBLEM!");
        }
        if (slotNum == 0xFFFFFF) {
            int slotOff = this.getTupleSlotEndOff() - 4;
            int newSlot = this.encodeSlotFields(this.decodeFirstSlotField(slot), tupleOff);
            this.setSlot(slotOff, newSlot);
            return newSlot;
        }
        int slotEndOff = this.getTupleSlotEndOff();
        int slotOff = this.getTupleSlotOff(slotNum);
        int length = slotOff - slotEndOff + 4;
        System.arraycopy(this.frame.getBuffer().array(), slotEndOff, this.frame.getBuffer().array(), slotEndOff - 4, length);
        int newSlot = this.encodeSlotFields(this.decodeFirstSlotField(slot), tupleOff);
        this.setSlot(slotOff, newSlot);
        return newSlot;
    }

    @Override
    public int getPrefixSlotOff(int tupleIndex) {
        return this.getPrefixSlotStartOff() - tupleIndex * 4;
    }

    @Override
    public int getTupleSlotOff(int tupleIndex) {
        return this.getTupleSlotStartOff() - tupleIndex * 4;
    }

    @Override
    public void setPrefixSlot(int tupleIndex, int slot) {
        this.buf.putInt(this.getPrefixSlotOff(tupleIndex), slot);
    }

    public int getGreatestKeyIndicator() {
        return 0xFFFFFF;
    }

    public int getErrorIndicator() {
        return 0xFFFFFE;
    }

    public void setFrame(ITreeIndexFrame frame) {
        this.frame = (BTreeFieldPrefixNSMLeafFrame)frame;
        this.buf = frame.getBuffer();
    }

    public int findTupleIndex(ITupleReference searchKey, ITreeIndexTupleReference frameTuple, MultiComparator multiCmp, FindTupleMode mode, FindTupleNoExactMatchPolicy matchPolicy) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public int getSlotStartOff() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public int getSlotEndOff() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public int getTupleOff(int slotOff) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public int getSlotOff(int tupleIndex) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public void setMultiComparator(MultiComparator cmp) {
        this.cmp = cmp;
    }
}

