/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.struct;

import java.util.Arrays;
import java.util.Optional;

public enum OperatorType {
    OR("or"),
    AND("and"),
    LT("<"),
    GT(">"),
    LE("<="),
    GE(">="),
    EQ("="),
    NEQ("!="),
    PLUS("+"),
    MINUS("-"),
    CONCAT("||"),
    MUL("*"),
    DIV("/"),
    MOD("%"),
    CARET("^"),
    IDIV("idiv"),
    FUZZY_EQ("~="),
    LIKE("like"),
    NOT_LIKE("not_like"),
    IN("in"),
    NOT_IN("not_in"),
    BETWEEN("between"),
    NOT_BETWEEN("not_between");

    private final String symbol;

    private OperatorType(String s) {
        this.symbol = s;
    }

    public String toString() {
        return this.symbol;
    }

    public static Optional<OperatorType> fromSymbol(String symbol) {
        return Arrays.stream(OperatorType.values()).filter(o -> o.symbol.equals(symbol)).findFirst();
    }
}

