/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.annotations.IRecordFieldDataGen;
import org.apache.asterix.common.annotations.UndeclaredFieldsDataGen;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.commons.lang3.ObjectUtils;

public class RecordTypeDefinition
implements TypeExpression {
    private final List<String> fieldNames = new ArrayList<String>();
    private final List<TypeExpression> fieldTypes = new ArrayList<TypeExpression>();
    private final List<IRecordFieldDataGen> fieldDataGen = new ArrayList<IRecordFieldDataGen>();
    private final List<Boolean> optionalFields = new ArrayList<Boolean>();
    private RecordKind recordKind;
    private UndeclaredFieldsDataGen undeclaredFieldsDataGen;

    @Override
    public TypeExpression.TypeExprKind getTypeKind() {
        return TypeExpression.TypeExprKind.RECORD;
    }

    public void addField(String name, TypeExpression type, Boolean nullable, IRecordFieldDataGen fldDataGen) {
        this.fieldNames.add(name);
        this.fieldTypes.add(type);
        this.optionalFields.add(nullable);
        this.fieldDataGen.add(fldDataGen);
    }

    public void addField(String name, TypeExpression type, Boolean optional) {
        this.fieldNames.add(name);
        this.fieldTypes.add(type);
        this.optionalFields.add(optional);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public List<TypeExpression> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<Boolean> getOptionableFields() {
        return this.optionalFields;
    }

    public List<IRecordFieldDataGen> getFieldDataGen() {
        return this.fieldDataGen;
    }

    public RecordKind getRecordKind() {
        return this.recordKind;
    }

    public void setRecordKind(RecordKind recordKind) {
        this.recordKind = recordKind;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public void setUndeclaredFieldsDataGen(UndeclaredFieldsDataGen undeclaredFieldsDataGen) {
        this.undeclaredFieldsDataGen = undeclaredFieldsDataGen;
    }

    public UndeclaredFieldsDataGen getUndeclaredFieldsDataGen() {
        return this.undeclaredFieldsDataGen;
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.fieldDataGen, this.fieldNames, this.fieldTypes, this.optionalFields, this.recordKind, this.undeclaredFieldsDataGen});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RecordTypeDefinition)) {
            return false;
        }
        RecordTypeDefinition target = (RecordTypeDefinition)object;
        boolean equals = this.fieldDataGen.equals(target.getFieldDataGen()) && this.fieldNames.equals(target.getFieldNames()) && this.fieldTypes.equals(target.getFieldNames()) && this.optionalFields.equals(target.getOptionableFields());
        equals = equals && ObjectUtils.equals((Object)((Object)this.recordKind), (Object)((Object)target.getRecordKind())) && ObjectUtils.equals((Object)this.undeclaredFieldsDataGen, (Object)target.getUndeclaredFieldsDataGen());
        return equals;
    }

    public static enum RecordKind {
        OPEN,
        CLOSED;

    }
}

