/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.clause;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.UpdateStatement;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.commons.lang3.ObjectUtils;

public class UpdateClause
implements Clause {
    private Expression target;
    private Expression value;
    private InsertStatement is;
    private DeleteStatement ds;
    private UpdateStatement us;
    private Expression condition;
    private UpdateClause ifbranch;
    private UpdateClause elsebranch;

    public UpdateClause(Expression target, Expression value, InsertStatement is, DeleteStatement ds, UpdateStatement us, Expression condition, UpdateClause ifbranch, UpdateClause elsebranch) {
        this.target = target;
        this.value = value;
        this.is = is;
        this.ds = ds;
        this.us = us;
        this.condition = condition;
        this.ifbranch = ifbranch;
        this.elsebranch = elsebranch;
    }

    public Expression getTarget() {
        return this.target;
    }

    public Expression getValue() {
        return this.value;
    }

    public InsertStatement getInsertStatement() {
        return this.is;
    }

    public DeleteStatement getDeleteStatement() {
        return this.ds;
    }

    public UpdateStatement getUpdateStatement() {
        return this.us;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public UpdateClause getIfBranch() {
        return this.ifbranch;
    }

    public UpdateClause getElseBranch() {
        return this.elsebranch;
    }

    @Override
    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.UPDATE_CLAUSE;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public boolean hasSet() {
        return this.target != null;
    }

    public boolean hasInsert() {
        return this.is != null;
    }

    public boolean hasDelete() {
        return this.ds != null;
    }

    public boolean hasUpdate() {
        return this.us != null;
    }

    public boolean hasIfElse() {
        return this.ifbranch != null;
    }

    public boolean hasElse() {
        return this.elsebranch != null;
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.condition, this.ds, this.elsebranch, this.ifbranch, this.is, this.target, this.us, this.value});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return false;
        }
        if (!(object instanceof UpdateClause)) {
            return false;
        }
        UpdateClause other = (UpdateClause)object;
        boolean equals = ObjectUtils.equals((Object)this.condition, (Object)other.condition) && ObjectUtils.equals((Object)this.ds, (Object)other.ds) && ObjectUtils.equals((Object)this.elsebranch, (Object)other.elsebranch) && ObjectUtils.equals((Object)this.ifbranch, (Object)other.ifbranch);
        equals = equals && ObjectUtils.equals((Object)this.is, (Object)other.is) && ObjectUtils.equals((Object)this.target, (Object)other.target) && ObjectUtils.equals((Object)this.us, (Object)other.us);
        return equals && ObjectUtils.equals((Object)this.value, (Object)other.value);
    }
}

