/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.tokenorder;

import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.asterix.fuzzyjoin.tokenorder.TokenRank;

public class TokenRankFrequency
implements TokenRank {
    private static final long serialVersionUID = 1L;
    private final HashMap<String, Integer> ranksMap = new HashMap();
    private int crtRank = 0;

    @Override
    public int add(String token) {
        int prevRank = this.crtRank++;
        this.ranksMap.put(token, prevRank);
        return prevRank;
    }

    @Override
    public Integer getRank(String token) {
        return this.ranksMap.get(token);
    }

    @Override
    public Collection<Integer> getTokenRanks(Iterable<String> tokens) {
        TreeSet<Integer> ranksCol = new TreeSet<Integer>();
        for (String token : tokens) {
            Integer rank = this.getRank(token);
            if (rank == null) continue;
            ranksCol.add(rank);
        }
        return ranksCol;
    }

    public String toString() {
        return "[" + this.crtRank + ",\n " + this.ranksMap + "\n]";
    }
}

