/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.similarity;

import org.apache.asterix.fuzzyjoin.similarity.PartialIntersect;
import org.apache.asterix.fuzzyjoin.tokenizer.Tokenizer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ISequenceIterator;

public abstract class SimilarityMetric {
    public static int getIntersectSize(ISequenceIterator tokensX, ISequenceIterator tokensY) throws HyracksDataException {
        int intersectSize = 0;
        while (tokensX.hasNext() && tokensY.hasNext()) {
            int cmp = tokensX.compare(tokensY);
            if (cmp > 0) {
                tokensY.next();
                continue;
            }
            if (cmp < 0) {
                tokensX.next();
                continue;
            }
            ++intersectSize;
            tokensX.next();
            tokensY.next();
        }
        return intersectSize;
    }

    public static int getIntersectSize(int[] tokensX, int startX, int lengthX, int[] tokensY, int startY, int lengthY) {
        int posX = 0;
        int posY = 0;
        int intersectSize = 0;
        while (posX < lengthX && posY < lengthY) {
            int tokenX = tokensX[startX + posX];
            int tokenY = tokensY[startY + posY];
            if (tokenX > tokenY) {
                ++posY;
                continue;
            }
            if (tokenX < tokenY) {
                ++posX;
                continue;
            }
            ++intersectSize;
            ++posX;
            ++posY;
        }
        return intersectSize;
    }

    public static int getIntersectSize(int[] tokensX, int startX, int[] tokensY, int startY) {
        return SimilarityMetric.getIntersectSize(tokensX, startX, tokensX.length, tokensY, startY, tokensY.length);
    }

    public static int getIntersectSize(int[] tokensX, int[] tokensY) {
        return SimilarityMetric.getIntersectSize(tokensX, 0, tokensX.length, tokensY, 0, tokensY.length);
    }

    public static PartialIntersect getPartialIntersectSize(int[] tokensX, int startX, int lengthX, int[] tokensY, int startY, int lengthY, int tokenStop) {
        PartialIntersect parInter = new PartialIntersect();
        SimilarityMetric.getPartialIntersectSize(tokensX, startX, lengthX, tokensY, startY, lengthY, tokenStop, parInter);
        return parInter;
    }

    public static void getPartialIntersectSize(int[] tokensX, int startX, int lengthX, int[] tokensY, int startY, int lengthY, int tokenStop, PartialIntersect parInter) {
        int posX = 0;
        int posY = 0;
        int intersectSize = 0;
        parInter.reset();
        while (posX < lengthX && posY < lengthY) {
            int tokenX = tokensX[startX + posX];
            int tokenY = tokensY[startY + posY];
            if (tokenX > tokenY) {
                ++posY;
                continue;
            }
            if (tokenX < tokenY) {
                ++posX;
                continue;
            }
            ++intersectSize;
            if (!parInter.isSet()) {
                parInter.posXStart = posX;
                parInter.posYStart = posY;
                parInter.set();
            }
            if (tokenX == tokenStop) {
                parInter.posXStop = posX;
                parInter.posYStop = posY;
                parInter.intersectSize = intersectSize;
            }
            ++posX;
            ++posY;
        }
    }

    public static PartialIntersect getPartialIntersectSize(int[] tokensX, int[] tokensY, int tokenStop) {
        return SimilarityMetric.getPartialIntersectSize(tokensX, 0, tokensX.length, tokensY, 0, tokensY.length, tokenStop);
    }

    public abstract float getSimilarity(int[] var1, int var2, int var3, int[] var4, int var5, int var6);

    public abstract float getSimilarity(int[] var1, int[] var2);

    public abstract float getSimilarity(String var1, String var2, Tokenizer var3);
}

