/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class FieldHashPartitionComputerFactory
implements ITuplePartitionComputerFactory {
    private static final long serialVersionUID = 1L;
    private final int[] hashFields;
    private final IBinaryHashFunctionFactory[] hashFunctionFactories;

    public FieldHashPartitionComputerFactory(int[] hashFields, IBinaryHashFunctionFactory[] hashFunctionFactories) {
        this.hashFields = hashFields;
        this.hashFunctionFactories = hashFunctionFactories;
    }

    public ITuplePartitionComputer createPartitioner() {
        final IBinaryHashFunction[] hashFunctions = new IBinaryHashFunction[this.hashFunctionFactories.length];
        for (int i = 0; i < this.hashFunctionFactories.length; ++i) {
            hashFunctions[i] = this.hashFunctionFactories[i].createBinaryHashFunction();
        }
        return new ITuplePartitionComputer(){

            public int partition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
                if (nParts == 1) {
                    return 0;
                }
                int h = 0;
                int startOffset = accessor.getTupleStartOffset(tIndex);
                int slotLength = accessor.getFieldSlotsLength();
                for (int j = 0; j < FieldHashPartitionComputerFactory.this.hashFields.length; ++j) {
                    int fIdx = FieldHashPartitionComputerFactory.this.hashFields[j];
                    IBinaryHashFunction hashFn = hashFunctions[j];
                    int fStart = accessor.getFieldStartOffset(tIndex, fIdx);
                    int fEnd = accessor.getFieldEndOffset(tIndex, fIdx);
                    int fh = hashFn.hash(accessor.getBuffer().array(), startOffset + slotLength + fStart, fEnd - fStart);
                    h = h * 31 + fh;
                }
                if (h < 0) {
                    h = -(h + 1);
                }
                return h % nParts;
            }
        };
    }
}

