/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.parsers;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.marshalling.ByteArraySerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import org.apache.hyracks.util.bytes.Base64Parser;

public class ByteArrayBase64ParserFactory
implements IValueParserFactory {
    private static final long serialVersionUID = 1L;
    public static final ByteArrayBase64ParserFactory INSTANCE = new ByteArrayBase64ParserFactory();

    private ByteArrayBase64ParserFactory() {
    }

    @Override
    public IValueParser createValueParser() {
        return new IValueParser(){
            Base64Parser parser = new Base64Parser();
            ByteArraySerializerDeserializer serializer = ByteArraySerializerDeserializer.INSTANCE;

            @Override
            public void parse(char[] input, int start, int length, DataOutput out) throws HyracksDataException {
                this.parser.generatePureByteArrayFromBase64String(input, start, length);
                try {
                    ByteArraySerializerDeserializer.serialize(this.parser.getByteArray(), 0, this.parser.getLength(), out);
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        };
    }
}

