/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.io.PrintWriter;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.visitor.QueryPrintVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.IndependentSubquery;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class SqlppAstPrintVisitor
extends QueryPrintVisitor
implements ISqlppVisitor<Void, Integer> {
    private final PrintWriter out;

    public SqlppAstPrintVisitor() {
        this.out = new PrintWriter(System.out);
    }

    public SqlppAstPrintVisitor(PrintWriter out) {
        super(out);
        this.out = out;
    }

    @Override
    public Void visit(FromClause fromClause, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "FROM [");
        int index = 0;
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            if (index > 0) {
                this.out.println(",");
            }
            fromTerm.accept(this, step + 1);
            ++index;
        }
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(FromTerm fromTerm, Integer step) throws CompilationException {
        fromTerm.getLeftExpression().accept((ILangVisitor)this, (Object)step);
        this.out.print(this.skip(step) + "AS ");
        fromTerm.getLeftVariable().accept((ILangVisitor)this, (Object)0);
        if (fromTerm.hasPositionalVariable()) {
            this.out.println(" AT ");
            fromTerm.getPositionalVariable().accept((ILangVisitor)this, (Object)0);
        }
        if (fromTerm.hasCorrelateClauses()) {
            for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
                correlateClause.accept(this, step);
            }
        }
        return null;
    }

    @Override
    public Void visit(JoinClause joinClause, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + (Object)((Object)joinClause.getJoinType()) + " JOIN");
        joinClause.getRightExpression().accept((ILangVisitor)this, (Object)(step + 1));
        this.out.print(this.skip(step + 1) + "AS ");
        joinClause.getRightVariable().accept((ILangVisitor)this, (Object)0);
        if (joinClause.hasPositionalVariable()) {
            this.out.print(" AT ");
            joinClause.getPositionalVariable().accept((ILangVisitor)this, (Object)0);
        }
        this.out.println(this.skip(step + 1) + "ON");
        joinClause.getConditionExpression().accept((ILangVisitor)this, (Object)(step + 1));
        return null;
    }

    @Override
    public Void visit(NestClause nestClause, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + (Object)((Object)nestClause.getJoinType()) + " NEST");
        nestClause.getRightExpression().accept((ILangVisitor)this, (Object)(step + 1));
        this.out.print(this.skip(step + 1) + "AS ");
        nestClause.getRightVariable().accept((ILangVisitor)this, (Object)0);
        if (nestClause.hasPositionalVariable()) {
            this.out.print(" AT ");
            nestClause.getPositionalVariable().accept((ILangVisitor)this, (Object)0);
        }
        this.out.println(this.skip(step + 1) + "ON");
        nestClause.getConditionExpression().accept((ILangVisitor)this, (Object)(step + 1));
        return null;
    }

    @Override
    public Void visit(Projection projection, Integer step) throws CompilationException {
        if (projection.star()) {
            this.out.println(this.skip(step) + "*");
        } else {
            projection.getExpression().accept((ILangVisitor)this, (Object)step);
            this.out.println(this.skip(step) + projection.getName());
        }
        return null;
    }

    @Override
    public Void visit(SelectBlock selectBlock, Integer step) throws CompilationException {
        selectBlock.getSelectClause().accept(this, step);
        if (selectBlock.hasFromClause()) {
            selectBlock.getFromClause().accept(this, step);
        }
        if (selectBlock.hasLetClauses()) {
            for (LetClause letClause : selectBlock.getLetList()) {
                letClause.accept((ILangVisitor)this, (Object)step);
            }
        }
        if (selectBlock.hasWhereClause()) {
            selectBlock.getWhereClause().accept((ILangVisitor)this, (Object)step);
        }
        if (selectBlock.hasGroupbyClause()) {
            selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)step);
            if (selectBlock.hasLetClausesAfterGroupby()) {
                for (LetClause letClause : selectBlock.getLetListAfterGroupby()) {
                    letClause.accept((ILangVisitor)this, (Object)step);
                }
            }
        }
        if (selectBlock.hasHavingClause()) {
            selectBlock.getHavingClause().accept(this, step);
        }
        return null;
    }

    @Override
    public Void visit(SelectClause selectClause, Integer step) throws CompilationException {
        if (selectClause.selectRegular()) {
            selectClause.getSelectRegular().accept(this, step);
        }
        if (selectClause.selectElement()) {
            selectClause.getSelectElement().accept(this, step);
        }
        return null;
    }

    @Override
    public Void visit(SelectElement selectElement, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "SELECT ELEMENT [");
        selectElement.getExpression().accept((ILangVisitor)this, (Object)step);
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(SelectRegular selectRegular, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "SELECT [");
        for (Projection projection : selectRegular.getProjections()) {
            projection.accept(this, step);
        }
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(SelectSetOperation selectSetOperation, Integer step) throws CompilationException {
        selectSetOperation.getLeftInput().accept(this, step);
        if (selectSetOperation.hasRightInputs()) {
            for (SetOperationRight right : selectSetOperation.getRightInputs()) {
                String all = right.isSetSemantics() ? " ALL " : "";
                this.out.println(this.skip(step) + (Object)((Object)right.getSetOpType()) + all);
                right.getSetOperationRightInput().accept(this, step + 1);
            }
        }
        return null;
    }

    @Override
    public Void visit(SelectExpression selectStatement, Integer step) throws CompilationException {
        int selectStep;
        if (selectStatement.isSubquery()) {
            this.out.println(this.skip(step) + "(");
        }
        int n = selectStep = selectStatement.isSubquery() ? step + 1 : step;
        if (selectStatement.hasLetClauses()) {
            for (LetClause letClause : selectStatement.getLetList()) {
                letClause.accept((ILangVisitor)this, (Object)selectStep);
            }
        }
        selectStatement.getSelectSetOperation().accept(this, selectStep);
        if (selectStatement.hasOrderby()) {
            selectStatement.getOrderbyClause().accept((ILangVisitor)this, (Object)selectStep);
        }
        if (selectStatement.hasLimit()) {
            selectStatement.getLimitClause().accept((ILangVisitor)this, (Object)selectStep);
        }
        if (selectStatement.isSubquery()) {
            this.out.println(this.skip(step) + ")");
        }
        return null;
    }

    @Override
    public Void visit(UnnestClause unnestClause, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + (Object)((Object)unnestClause.getJoinType()) + " UNNEST");
        unnestClause.getRightExpression().accept((ILangVisitor)this, (Object)(step + 1));
        this.out.print(this.skip(step + 1) + " AS ");
        unnestClause.getRightVariable().accept((ILangVisitor)this, (Object)0);
        if (unnestClause.hasPositionalVariable()) {
            this.out.println(" AT");
            unnestClause.getPositionalVariable().accept((ILangVisitor)this, (Object)0);
        }
        return null;
    }

    @Override
    public Void visit(HavingClause havingClause, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + " HAVING");
        havingClause.getFilterExpression().accept((ILangVisitor)this, (Object)(step + 1));
        return null;
    }

    public Void visit(CallExpr pf, Integer step) throws CompilationException {
        FunctionSignature functionSignature = pf.getFunctionSignature();
        FunctionSignature normalizedFunctionSignature = FunctionMapUtil.normalizeBuiltinFunctionSignature(functionSignature, false);
        if (BuiltinFunctions.isBuiltinCompilerFunction((FunctionSignature)normalizedFunctionSignature, (boolean)true)) {
            functionSignature = normalizedFunctionSignature;
        }
        this.out.println(this.skip(step) + "FunctionCall " + functionSignature.toString() + "[");
        for (Expression expr : pf.getExprList()) {
            expr.accept((ILangVisitor)this, (Object)(step + 1));
        }
        this.out.println(this.skip(step) + "]");
        return null;
    }

    public Void visit(GroupbyClause gc, Integer step) throws CompilationException {
        if (gc.isGroupAll()) {
            this.out.println(this.skip(step) + "Group All");
            return null;
        }
        this.out.println(this.skip(step) + "Groupby");
        for (GbyVariableExpressionPair pair : gc.getGbyPairList()) {
            if (pair.getVar() != null) {
                pair.getVar().accept((ILangVisitor)this, (Object)(step + 1));
                this.out.println(this.skip(step + 1) + ":=");
            }
            pair.getExpr().accept((ILangVisitor)this, (Object)(step + 1));
        }
        if (gc.hasGroupVar()) {
            this.out.print(this.skip(step + 1) + "GROUP AS ");
            gc.getGroupVar().accept((ILangVisitor)this, (Object)0);
            if (gc.hasGroupFieldList()) {
                this.out.println(this.skip(step + 1) + "(");
                for (Pair field : gc.getGroupFieldList()) {
                    this.out.print(this.skip(step + 2) + field.second + ":=");
                    ((Expression)field.first).accept((ILangVisitor)this, (Object)0);
                }
                this.out.println(this.skip(step + 1) + ")");
            }
        }
        this.out.println();
        return null;
    }

    @Override
    public Void visit(IndependentSubquery independentSubquery, Integer arg) throws CompilationException {
        independentSubquery.getExpr().accept((ILangVisitor)this, (Object)arg);
        return null;
    }

    @Override
    public Void visit(CaseExpression caseExpr, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "CASE");
        caseExpr.getConditionExpr().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.println();
        List<Expression> whenExprs = caseExpr.getWhenExprs();
        List<Expression> thenExprs = caseExpr.getThenExprs();
        for (int index = 0; index < whenExprs.size(); ++index) {
            this.out.print(this.skip(step) + "WHEN ");
            whenExprs.get(index).accept((ILangVisitor)this, (Object)(step + 2));
            this.out.print(this.skip(step) + "THEN ");
            thenExprs.get(index).accept((ILangVisitor)this, (Object)(step + 2));
            this.out.println();
        }
        this.out.print(this.skip(step) + "ELSE ");
        caseExpr.getElseExpr().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.println();
        this.out.println(this.skip(step) + "END");
        return null;
    }
}

