/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.IndependentSubquery;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppQueryExpressionVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class FreeVariableVisitor
extends AbstractSqlppQueryExpressionVisitor<Void, Collection<VariableExpr>> {
    @Override
    public Void visit(FromClause fromClause, Collection<VariableExpr> freeVars) throws CompilationException {
        HashSet<VariableExpr> bindingVars = new HashSet<VariableExpr>();
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            HashSet fromTermFreeVars = new HashSet();
            fromTerm.accept(this, fromTermFreeVars);
            fromTermFreeVars.removeAll(bindingVars);
            bindingVars.addAll(SqlppVariableUtil.getBindingVariables(fromTerm));
            freeVars.addAll(fromTermFreeVars);
        }
        return null;
    }

    @Override
    public Void visit(FromTerm fromTerm, Collection<VariableExpr> freeVars) throws CompilationException {
        HashSet<VariableExpr> bindingVariables = new HashSet<VariableExpr>();
        fromTerm.getLeftExpression().accept((ILangVisitor)this, freeVars);
        bindingVariables.add(fromTerm.getLeftVariable());
        if (fromTerm.hasPositionalVariable()) {
            bindingVariables.add(fromTerm.getPositionalVariable());
        }
        for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
            HashSet correlateFreeVars = new HashSet();
            correlateClause.accept(this, correlateFreeVars);
            if (correlateClause.getClauseType() != Clause.ClauseType.JOIN_CLAUSE) {
                correlateFreeVars.removeAll(bindingVariables);
                bindingVariables.add(correlateClause.getRightVariable());
                if (correlateClause.hasPositionalVariable()) {
                    bindingVariables.add(correlateClause.getPositionalVariable());
                }
            }
            freeVars.addAll(correlateFreeVars);
        }
        return null;
    }

    @Override
    public Void visit(JoinClause joinClause, Collection<VariableExpr> freeVars) throws CompilationException {
        this.visitJoinAndNest(joinClause, joinClause.getConditionExpression(), freeVars);
        return null;
    }

    @Override
    public Void visit(NestClause nestClause, Collection<VariableExpr> freeVars) throws CompilationException {
        this.visitJoinAndNest(nestClause, nestClause.getConditionExpression(), freeVars);
        return null;
    }

    @Override
    public Void visit(UnnestClause unnestClause, Collection<VariableExpr> freeVars) throws CompilationException {
        unnestClause.getRightExpression().accept((ILangVisitor)this, freeVars);
        return null;
    }

    @Override
    public Void visit(Projection projection, Collection<VariableExpr> freeVars) throws CompilationException {
        if (!projection.star()) {
            projection.getExpression().accept((ILangVisitor)this, freeVars);
        }
        return null;
    }

    @Override
    public Void visit(SelectBlock selectBlock, Collection<VariableExpr> freeVars) throws CompilationException {
        HashSet<VariableExpr> selectFreeVars = new HashSet<VariableExpr>();
        HashSet fromFreeVars = new HashSet();
        HashSet<VariableExpr> letsFreeVars = new HashSet<VariableExpr>();
        HashSet whereFreeVars = new HashSet();
        HashSet gbyFreeVars = new HashSet();
        HashSet<VariableExpr> gbyLetsFreeVars = new HashSet<VariableExpr>();
        Collection<VariableExpr> fromBindingVars = SqlppVariableUtil.getBindingVariables(selectBlock.getFromClause());
        Collection<VariableExpr> letsBindingVars = SqlppVariableUtil.getBindingVariables(selectBlock.getLetList());
        Collection<VariableExpr> gbyBindingVars = SqlppVariableUtil.getBindingVariables(selectBlock.getGroupbyClause());
        Collection<VariableExpr> gbyLetsBindingVars = SqlppVariableUtil.getBindingVariables(selectBlock.getLetListAfterGroupby());
        selectBlock.getSelectClause().accept(this, selectFreeVars);
        this.removeAllBindingVarsInSelectBlock(selectFreeVars, fromBindingVars, letsBindingVars, gbyLetsBindingVars);
        if (selectBlock.hasFromClause()) {
            selectBlock.getFromClause().accept(this, fromFreeVars);
        }
        if (selectBlock.hasLetClauses()) {
            this.visitLetClauses(selectBlock.getLetList(), letsFreeVars);
            letsFreeVars.removeAll(fromBindingVars);
        }
        if (selectBlock.hasWhereClause()) {
            selectBlock.getWhereClause().accept((ILangVisitor)this, whereFreeVars);
            whereFreeVars.removeAll(fromBindingVars);
            whereFreeVars.removeAll(letsBindingVars);
        }
        if (selectBlock.hasGroupbyClause()) {
            selectBlock.getGroupbyClause().accept((ILangVisitor)this, gbyFreeVars);
            gbyFreeVars.removeAll(fromBindingVars);
            gbyFreeVars.removeAll(letsBindingVars);
            if (selectBlock.hasLetClausesAfterGroupby()) {
                this.visitLetClauses(selectBlock.getLetListAfterGroupby(), gbyLetsFreeVars);
                gbyLetsFreeVars.removeAll(fromBindingVars);
                gbyLetsFreeVars.removeAll(letsBindingVars);
                gbyLetsFreeVars.removeAll(gbyBindingVars);
            }
            if (selectBlock.hasHavingClause()) {
                selectBlock.getHavingClause().accept(this, selectFreeVars);
                this.removeAllBindingVarsInSelectBlock(selectFreeVars, fromBindingVars, letsBindingVars, gbyLetsBindingVars);
            }
        }
        this.removeAllBindingVarsInSelectBlock(freeVars, fromBindingVars, letsBindingVars, gbyLetsBindingVars);
        freeVars.addAll(selectFreeVars);
        freeVars.addAll(fromFreeVars);
        freeVars.addAll(letsFreeVars);
        freeVars.addAll(whereFreeVars);
        freeVars.addAll(gbyFreeVars);
        freeVars.addAll(gbyLetsFreeVars);
        return null;
    }

    @Override
    public Void visit(SelectClause selectClause, Collection<VariableExpr> freeVars) throws CompilationException {
        if (selectClause.selectElement()) {
            selectClause.getSelectElement().accept(this, freeVars);
        }
        if (selectClause.selectRegular()) {
            selectClause.getSelectRegular().accept(this, freeVars);
        }
        return null;
    }

    @Override
    public Void visit(SelectElement selectElement, Collection<VariableExpr> freeVars) throws CompilationException {
        selectElement.getExpression().accept((ILangVisitor)this, freeVars);
        return null;
    }

    @Override
    public Void visit(SelectRegular selectRegular, Collection<VariableExpr> freeVars) throws CompilationException {
        for (Projection projection : selectRegular.getProjections()) {
            projection.accept(this, freeVars);
        }
        return null;
    }

    @Override
    public Void visit(SelectSetOperation selectSetOperation, Collection<VariableExpr> freeVars) throws CompilationException {
        selectSetOperation.getLeftInput().accept(this, freeVars);
        for (SetOperationRight right : selectSetOperation.getRightInputs()) {
            right.getSetOperationRightInput().accept(this, freeVars);
        }
        return null;
    }

    @Override
    public Void visit(HavingClause havingClause, Collection<VariableExpr> freeVars) throws CompilationException {
        havingClause.getFilterExpression().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(Query q, Collection<VariableExpr> freeVars) throws CompilationException {
        q.getBody().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(FunctionDecl fd, Collection<VariableExpr> freeVars) throws CompilationException {
        fd.getFuncBody().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(WhereClause whereClause, Collection<VariableExpr> freeVars) throws CompilationException {
        whereClause.getWhereExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(OrderbyClause oc, Collection<VariableExpr> freeVars) throws CompilationException {
        this.visit(oc.getOrderbyList(), freeVars);
        return null;
    }

    public Void visit(GroupbyClause gc, Collection<VariableExpr> freeVars) throws CompilationException {
        for (GbyVariableExpressionPair gbyVarExpr : gc.getGbyPairList()) {
            gbyVarExpr.getExpr().accept((ILangVisitor)this, freeVars);
        }
        for (GbyVariableExpressionPair decorVarExpr : gc.getDecorPairList()) {
            decorVarExpr.getExpr().accept((ILangVisitor)this, freeVars);
        }
        if (gc.hasGroupFieldList()) {
            for (Pair groupField : gc.getGroupFieldList()) {
                ((Expression)groupField.first).accept((ILangVisitor)this, freeVars);
            }
        }
        return null;
    }

    public Void visit(LimitClause limitClause, Collection<VariableExpr> freeVars) throws CompilationException {
        limitClause.getLimitExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(LetClause letClause, Collection<VariableExpr> freeVars) throws CompilationException {
        letClause.getBindingExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    @Override
    public Void visit(SelectExpression selectExpression, Collection<VariableExpr> freeVars) throws CompilationException {
        HashSet<VariableExpr> letsFreeVars = new HashSet<VariableExpr>();
        HashSet selectFreeVars = new HashSet();
        this.visitLetClauses(selectExpression.getLetList(), letsFreeVars);
        if (selectExpression.hasOrderby()) {
            for (Expression orderExpr : selectExpression.getOrderbyClause().getOrderbyList()) {
                orderExpr.accept((ILangVisitor)this, selectFreeVars);
            }
        }
        if (selectExpression.hasLimit()) {
            selectExpression.getLimitClause().accept((ILangVisitor)this, selectFreeVars);
        }
        selectExpression.getSelectSetOperation().accept(this, selectFreeVars);
        selectFreeVars.removeAll(SqlppVariableUtil.getBindingVariables(selectExpression.getLetList()));
        freeVars.addAll(letsFreeVars);
        freeVars.addAll(selectFreeVars);
        return null;
    }

    public Void visit(LiteralExpr l, Collection<VariableExpr> freeVars) throws CompilationException {
        return null;
    }

    public Void visit(ListConstructor lc, Collection<VariableExpr> freeVars) throws CompilationException {
        this.visit(lc.getExprList(), freeVars);
        return null;
    }

    public Void visit(RecordConstructor rc, Collection<VariableExpr> freeVars) throws CompilationException {
        for (FieldBinding binding : rc.getFbList()) {
            binding.getLeftExpr().accept((ILangVisitor)this, freeVars);
            binding.getRightExpr().accept((ILangVisitor)this, freeVars);
        }
        return null;
    }

    public Void visit(OperatorExpr operatorExpr, Collection<VariableExpr> freeVars) throws CompilationException {
        this.visit(operatorExpr.getExprList(), freeVars);
        return null;
    }

    public Void visit(IfExpr ifExpr, Collection<VariableExpr> freeVars) throws CompilationException {
        ifExpr.getCondExpr().accept((ILangVisitor)this, freeVars);
        ifExpr.getThenExpr().accept((ILangVisitor)this, freeVars);
        ifExpr.getElseExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(QuantifiedExpression qe, Collection<VariableExpr> freeVars) throws CompilationException {
        for (QuantifiedPair pair : qe.getQuantifiedList()) {
            pair.getExpr().accept((ILangVisitor)this, freeVars);
        }
        qe.getSatisfiesExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(CallExpr callExpr, Collection<VariableExpr> freeVars) throws CompilationException {
        for (Expression expr : callExpr.getExprList()) {
            expr.accept((ILangVisitor)this, freeVars);
        }
        return null;
    }

    public Void visit(VariableExpr varExpr, Collection<VariableExpr> freeVars) throws CompilationException {
        freeVars.add(varExpr);
        return null;
    }

    public Void visit(UnaryExpr u, Collection<VariableExpr> freeVars) throws CompilationException {
        u.getExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(FieldAccessor fa, Collection<VariableExpr> freeVars) throws CompilationException {
        fa.getExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    public Void visit(IndexAccessor ia, Collection<VariableExpr> freeVars) throws CompilationException {
        ia.getExpr().accept((ILangVisitor)this, freeVars);
        if (ia.getIndexExpr() != null) {
            ia.getIndexExpr();
        }
        return null;
    }

    @Override
    public Void visit(IndependentSubquery independentSubquery, Collection<VariableExpr> freeVars) throws CompilationException {
        independentSubquery.getExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    @Override
    public Void visit(CaseExpression caseExpr, Collection<VariableExpr> freeVars) throws CompilationException {
        caseExpr.getConditionExpr().accept((ILangVisitor)this, freeVars);
        this.visit(caseExpr.getWhenExprs(), freeVars);
        this.visit(caseExpr.getThenExprs(), freeVars);
        caseExpr.getElseExpr().accept((ILangVisitor)this, freeVars);
        return null;
    }

    private void visitLetClauses(List<LetClause> letClauses, Collection<VariableExpr> freeVars) throws CompilationException {
        if (letClauses == null || letClauses.isEmpty()) {
            return;
        }
        HashSet<VariableExpr> bindingVars = new HashSet<VariableExpr>();
        for (LetClause letClause : letClauses) {
            HashSet letFreeVars = new HashSet();
            letClause.accept((ILangVisitor)this, letFreeVars);
            letFreeVars.removeAll(bindingVars);
            freeVars.addAll(letFreeVars);
            bindingVars.add(letClause.getVarExpr());
        }
    }

    private void visitJoinAndNest(AbstractBinaryCorrelateClause clause, Expression condition, Collection<VariableExpr> freeVars) throws CompilationException {
        clause.getRightExpression().accept((ILangVisitor)this, freeVars);
        HashSet conditionFreeVars = new HashSet();
        condition.accept((ILangVisitor)this, freeVars);
        conditionFreeVars.remove(clause.getRightVariable());
        if (clause.hasPositionalVariable()) {
            conditionFreeVars.remove(clause.getPositionalVariable());
        }
        freeVars.addAll(conditionFreeVars);
    }

    private void visit(List<Expression> exprs, Collection<VariableExpr> arg) throws CompilationException {
        for (Expression expr : exprs) {
            expr.accept((ILangVisitor)this, arg);
        }
    }

    private void removeAllBindingVarsInSelectBlock(Collection<VariableExpr> selectFreeVars, Collection<VariableExpr> fromBindingVars, Collection<VariableExpr> letsBindingVars, Collection<VariableExpr> gbyLetsBindingVars) {
        selectFreeVars.removeAll(fromBindingVars);
        selectFreeVars.removeAll(letsBindingVars);
        selectFreeVars.removeAll(gbyLetsBindingVars);
        selectFreeVars.removeAll(gbyLetsBindingVars);
    }
}

