/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.util.CommonFunctionMapUtil;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;

public class FunctionMapUtil {
    private static final String CORE_AGGREGATE_PREFIX = "coll_";
    private static final String CORE_SQL_AGGREGATE_PREFIX = "array_";
    private static final String INTERNAL_SQL_AGGREGATE_PREFIX = "sql-";
    private static final Map<String, String> LIST_INPUT_FUNCTION_MAP = new HashMap<String, String>();

    public static boolean isSql92AggregateFunction(FunctionSignature signature) throws CompilationException {
        IFunctionInfo finfo = FunctionUtil.getFunctionInfo((FunctionIdentifier)new FunctionIdentifier("asterix", signature.getName().toLowerCase(), signature.getArity()));
        if (finfo == null) {
            return false;
        }
        return BuiltinFunctions.getAggregateFunction((FunctionIdentifier)finfo.getFunctionIdentifier()) != null;
    }

    public static boolean isCoreAggregateFunction(FunctionSignature fs) {
        String name = fs.getName().toLowerCase();
        boolean coreAgg = name.startsWith(CORE_AGGREGATE_PREFIX);
        boolean coreSqlAgg = name.startsWith(CORE_SQL_AGGREGATE_PREFIX);
        if (!coreAgg && !coreSqlAgg) {
            return false;
        }
        String internalName = coreAgg ? name.substring(CORE_AGGREGATE_PREFIX.length()) : INTERNAL_SQL_AGGREGATE_PREFIX + name.substring(CORE_SQL_AGGREGATE_PREFIX.length());
        IFunctionInfo finfo = FunctionUtil.getFunctionInfo((FunctionIdentifier)new FunctionIdentifier("asterix", internalName, fs.getArity()));
        if (finfo == null) {
            return false;
        }
        return BuiltinFunctions.getAggregateFunction((FunctionIdentifier)finfo.getFunctionIdentifier()) != null;
    }

    public static FunctionSignature sql92ToCoreAggregateFunction(FunctionSignature fs) throws CompilationException {
        if (!FunctionMapUtil.isSql92AggregateFunction(fs)) {
            return fs;
        }
        return new FunctionSignature(fs.getNamespace(), CORE_SQL_AGGREGATE_PREFIX + fs.getName(), fs.getArity());
    }

    public static FunctionSignature normalizeBuiltinFunctionSignature(FunctionSignature fs, boolean checkSql92Aggregate) throws CompilationException {
        if (FunctionMapUtil.isCoreAggregateFunction(fs)) {
            return FunctionMapUtil.internalizeCoreAggregateFunctionName(fs);
        }
        if (checkSql92Aggregate && FunctionMapUtil.isSql92AggregateFunction(fs)) {
            throw new CompilationException(fs.getName() + " is a SQL-92 aggregate function. The SQL++ core aggregate function " + CORE_SQL_AGGREGATE_PREFIX + fs.getName().toLowerCase() + " could potentially express the intent.");
        }
        String mappedName = CommonFunctionMapUtil.normalizeBuiltinFunctionSignature((FunctionSignature)fs).getName();
        return new FunctionSignature(fs.getNamespace(), mappedName, fs.getArity());
    }

    public static CallExpr normalizedListInputFunctions(CallExpr callExpr) {
        FunctionSignature fs = callExpr.getFunctionSignature();
        String internalFuncName = LIST_INPUT_FUNCTION_MAP.get(fs.getName().toLowerCase());
        if (internalFuncName == null) {
            return callExpr;
        }
        callExpr.setFunctionSignature(new FunctionSignature("asterix", internalFuncName, 1));
        callExpr.setExprList(new ArrayList<ListConstructor>(Collections.singletonList(new ListConstructor(ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR, callExpr.getExprList()))));
        return callExpr;
    }

    private static FunctionSignature internalizeCoreAggregateFunctionName(FunctionSignature fs) throws CompilationException {
        String name = fs.getName().toLowerCase();
        boolean coreAgg = name.startsWith(CORE_AGGREGATE_PREFIX);
        String lowerCaseName = coreAgg ? name.substring(CORE_AGGREGATE_PREFIX.length()) : INTERNAL_SQL_AGGREGATE_PREFIX + name.substring(CORE_SQL_AGGREGATE_PREFIX.length());
        return new FunctionSignature(fs.getNamespace(), lowerCaseName, fs.getArity());
    }

    static {
        LIST_INPUT_FUNCTION_MAP.put("concat", "string-concat");
        LIST_INPUT_FUNCTION_MAP.put("greatest", "array_max");
        LIST_INPUT_FUNCTION_MAP.put("least", "array_min");
    }
}

