/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayList;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.CheckDatasetOnlyResolutionVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class VariableCheckAndRewriteVisitor
extends AbstractSqlppExpressionScopingVisitor {
    protected final FunctionSignature datasetFunction = new FunctionSignature("Metadata", "dataset", 1);
    protected final boolean overwrite;
    protected final MetadataProvider metadataProvider;

    public VariableCheckAndRewriteVisitor(LangRewritingContext context, boolean overwrite, MetadataProvider metadataProvider) {
        super(context);
        this.overwrite = overwrite;
        this.metadataProvider = metadataProvider;
    }

    @Override
    public Expression visit(FieldAccessor fa, ILangExpression parent) throws CompilationException {
        CallExpr callExpr;
        Expression leadingExpr = fa.getExpr();
        if (leadingExpr.getKind() != Expression.Kind.VARIABLE_EXPRESSION) {
            fa.setExpr((Expression)leadingExpr.accept((ILangVisitor)this, (Object)fa));
            return fa;
        }
        VariableExpr varExpr = (VariableExpr)leadingExpr;
        String lastIdentifier = fa.getIdent().getValue();
        Expression resolvedExpr = this.resolve(varExpr, SqlppVariableUtil.toUserDefinedVariableName(varExpr.getVar().getValue()).getValue(), lastIdentifier, (Expression)fa, parent);
        if (resolvedExpr.getKind() == Expression.Kind.CALL_EXPRESSION && (callExpr = (CallExpr)resolvedExpr).getFunctionSignature().equals((Object)this.datasetFunction)) {
            return resolvedExpr;
        }
        fa.setExpr(resolvedExpr);
        return fa;
    }

    @Override
    public Expression visit(VariableExpr varExpr, ILangExpression parent) throws CompilationException {
        return this.resolve(varExpr, null, SqlppVariableUtil.toUserDefinedVariableName(varExpr.getVar().getValue()).getValue(), (Expression)varExpr, parent);
    }

    private Expression resolve(VariableExpr varExpr, String dataverseName, String datasetName, Expression originalExprWithUndefinedIdentifier, ILangExpression parent) throws CompilationException {
        String varName = varExpr.getVar().getValue();
        this.checkError(varName);
        if (!this.rewriteNeeded(varExpr)) {
            return varExpr;
        }
        Set<VariableExpr> liveVars = SqlppVariableUtil.getLiveVariables(this.scopeChecker.getCurrentScope(), false);
        boolean resolveToDatasetOnly = this.resolveToDatasetOnly(originalExprWithUndefinedIdentifier, parent);
        boolean resolveAsDataset = this.datasetExists(dataverseName, datasetName);
        if (resolveToDatasetOnly) {
            if (resolveAsDataset) {
                return this.wrapWithDatasetFunction(dataverseName, datasetName);
            }
            this.throwUnresolvableError(dataverseName, datasetName);
        }
        return this.wrapWithResolveFunction(varExpr, liveVars);
    }

    private void throwUnresolvableError(String dataverseName, String datasetName) throws CompilationException {
        String defaultDataverseName = this.metadataProvider.getDefaultDataverseName();
        if (dataverseName == null && defaultDataverseName == null) {
            throw new CompilationException("Cannot find dataset " + datasetName + " because there is no dataverse declared, nor an alias with name " + datasetName + "!");
        }
        throw new CompilationException("Cannot find dataset " + datasetName + " in dataverse " + (dataverseName == null ? defaultDataverseName : dataverseName) + " nor an alias with name " + datasetName + "!");
    }

    private void checkError(String varName) throws CompilationException {
        if (this.scopeChecker.isInForbiddenScopes(varName)) {
            throw new CompilationException("Inside limit clauses, it is disallowed to reference a variable having the same name as any variable bound in the same scope as the limit clause.");
        }
    }

    private boolean resolveToDatasetOnly(Expression originalExpressionWithUndefinedIdentifier, ILangExpression parent) throws CompilationException {
        CheckDatasetOnlyResolutionVisitor visitor = new CheckDatasetOnlyResolutionVisitor();
        return (Boolean)parent.accept((ILangVisitor)visitor, (Object)originalExpressionWithUndefinedIdentifier);
    }

    private boolean rewriteNeeded(VariableExpr varExpr) throws CompilationException {
        String varName = varExpr.getVar().getValue();
        Identifier ident = this.scopeChecker.lookupSymbol(varName);
        if (ident != null) {
            varExpr.setIsNewVar(false);
            varExpr.setVar((VarIdentifier)ident);
            return false;
        }
        return this.overwrite;
    }

    private Expression wrapWithDatasetFunction(String dataverseName, String datasetName) throws CompilationException {
        String fullyQualifiedName = dataverseName == null ? datasetName : dataverseName + "." + datasetName;
        ArrayList<LiteralExpr> argList = new ArrayList<LiteralExpr>();
        argList.add(new LiteralExpr((Literal)new StringLiteral(fullyQualifiedName)));
        return new CallExpr(this.datasetFunction, argList);
    }

    private boolean datasetExists(String dataverseName, String datasetName) throws CompilationException {
        try {
            if (this.metadataProvider.findDataset(dataverseName, datasetName) != null) {
                return true;
            }
            return this.fullyQualifiedDatasetNameExists(datasetName);
        }
        catch (AlgebricksException e) {
            throw new CompilationException((Throwable)e);
        }
    }

    private boolean fullyQualifiedDatasetNameExists(String name) throws AlgebricksException {
        if (!name.contains(".")) {
            return false;
        }
        String[] path = name.split("\\.");
        if (path.length != 2) {
            return false;
        }
        return this.metadataProvider.findDataset(path[0], path[1]) != null;
    }
}

