/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;

public class SqlppGroupBySugarVisitor
extends AbstractSqlppExpressionScopingVisitor {
    private final Expression groupVar;
    private final Collection<VariableExpr> fieldVars;

    public SqlppGroupBySugarVisitor(LangRewritingContext context, Expression groupVar, Collection<VariableExpr> fieldVars) {
        super(context);
        this.groupVar = groupVar;
        this.fieldVars = fieldVars;
    }

    @Override
    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        ArrayList<Object> newExprList = new ArrayList<Object>();
        FunctionSignature signature = callExpr.getFunctionSignature();
        boolean aggregate = FunctionMapUtil.isSql92AggregateFunction(signature);
        boolean rewritten = false;
        for (Expression expr : callExpr.getExprList()) {
            Expression newExpr = aggregate ? this.wrapAggregationArgument(expr) : expr;
            rewritten |= newExpr != expr;
            newExprList.add(newExpr.accept((ILangVisitor)this, (Object)arg));
        }
        if (rewritten) {
            callExpr.setFunctionSignature(FunctionMapUtil.sql92ToCoreAggregateFunction(signature));
        }
        callExpr.setExprList(newExprList);
        return callExpr;
    }

    private Expression wrapAggregationArgument(Expression argExpr) throws CompilationException {
        Expression expr = argExpr;
        Set<VariableExpr> freeVars = SqlppRewriteUtil.getFreeVariable(expr);
        VariableExpr fromBindingVar = new VariableExpr(this.context.newVariable());
        FromTerm fromTerm = new FromTerm(this.groupVar, fromBindingVar, null, null);
        FromClause fromClause = new FromClause(Collections.singletonList(fromTerm));
        HashMap<Expression, Expression> varExprMap = new HashMap<Expression, Expression>();
        for (VariableExpr usedVar : freeVars) {
            if (!this.fieldVars.contains(usedVar)) continue;
            varExprMap.put((Expression)usedVar, (Expression)new FieldAccessor((Expression)fromBindingVar, (Identifier)SqlppVariableUtil.toUserDefinedVariableName(usedVar.getVar())));
        }
        SelectElement selectElement = new SelectElement(SqlppRewriteUtil.substituteExpression(expr, varExprMap, this.context));
        SelectClause selectClause = new SelectClause(selectElement, null, false);
        SelectBlock selectBlock = new SelectBlock(selectClause, fromClause, null, null, null, null, null);
        SelectSetOperation selectSetOperation = new SelectSetOperation(new SetOperationInput(selectBlock, null), null);
        return new SelectExpression(null, selectSetOperation, null, null, true);
    }
}

