/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.literal.NullLiteral;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.commons.lang3.ObjectUtils;

public class CaseExpression
implements Expression {
    private Expression conditionExpr;
    private List<Expression> whenExprs = new ArrayList<Expression>();
    private List<Expression> thenExprs = new ArrayList<Expression>();
    private Expression elseExpr;

    public CaseExpression(Expression conditionExpr, List<Expression> whenExprs, List<Expression> thenExprs, Expression elseExpr) {
        this.conditionExpr = conditionExpr;
        this.whenExprs.addAll(whenExprs);
        this.thenExprs.addAll(thenExprs);
        this.elseExpr = elseExpr == null ? new LiteralExpr((Literal)NullLiteral.INSTANCE) : elseExpr;
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Expression.Kind getKind() {
        return Expression.Kind.CASE_EXPRESSION;
    }

    public Expression getConditionExpr() {
        return this.conditionExpr;
    }

    public Expression getElseExpr() {
        return this.elseExpr;
    }

    public List<Expression> getWhenExprs() {
        return this.whenExprs;
    }

    public List<Expression> getThenExprs() {
        return this.thenExprs;
    }

    public void setConditionExpr(Expression conditionExpr) {
        this.conditionExpr = conditionExpr;
    }

    public void setElseExpr(Expression elseExpr) {
        this.elseExpr = elseExpr;
    }

    public void setWhenExprs(List<Expression> whenExprs) {
        this.whenExprs = whenExprs;
    }

    public void setThenExprs(List<Expression> thenExprs) {
        this.thenExprs = thenExprs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CASE ");
        sb.append(this.conditionExpr);
        sb.append("\n");
        for (int index = 0; index < this.whenExprs.size(); ++index) {
            sb.append("WHEN ");
            sb.append(this.whenExprs.get(index));
            sb.append(" THEN ");
            sb.append(this.thenExprs.get(index));
            sb.append("\n");
        }
        sb.append("ELSE ");
        sb.append(this.elseExpr);
        sb.append("END\n");
        return sb.toString();
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.conditionExpr, this.elseExpr, this.thenExprs, this.whenExprs});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CaseExpression)) {
            return false;
        }
        CaseExpression target = (CaseExpression)object;
        return ObjectUtils.equals((Object)this.conditionExpr, (Object)target.conditionExpr) && ObjectUtils.equals((Object)this.elseExpr, (Object)target.elseExpr) && ObjectUtils.equals(this.thenExprs, target.thenExprs) && ObjectUtils.equals(this.thenExprs, this.thenExprs);
    }
}

