/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.clause;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.commons.lang3.ObjectUtils;

public class Projection
implements Clause {
    private Expression expr;
    private String name;
    private boolean star;
    private boolean exprStar;

    public Projection(Expression expr, String name, boolean star, boolean exprStar) {
        this.expr = expr;
        this.name = name;
        this.star = star;
        this.exprStar = exprStar;
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.PROJECTION;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public void setExpression(Expression expr) {
        this.expr = expr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean star() {
        return this.star;
    }

    public boolean exprStar() {
        return this.exprStar;
    }

    public String toString() {
        return this.star ? "*" : String.valueOf(this.expr) + (this.exprStar ? ".*" : (this.hasName() ? " as " + this.getName() : ""));
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.expr, this.exprStar, this.name, this.star});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Projection)) {
            return false;
        }
        Projection target = (Projection)object;
        return ObjectUtils.equals((Object)this.expr, (Object)target.expr) && ObjectUtils.equals((Object)this.exprStar, (Object)target.exprStar) && ObjectUtils.equals((Object)this.name, (Object)target.name) && ObjectUtils.equals((Object)this.star, (Object)target.star);
    }
}

