/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushAggregateIntoNestedSubplanRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        HashMap<LogicalVariable, Integer> nspAggVars = new HashMap<LogicalVariable, Integer>();
        HashMap<LogicalVariable, AbstractOperatorWithNestedPlans> nspWithAgg = new HashMap<LogicalVariable, AbstractOperatorWithNestedPlans>();
        HashMap<LogicalVariable, Integer> nspAggVarToPlanIndex = new HashMap<LogicalVariable, Integer>();
        HashMap<ILogicalExpression, ILogicalExpression> aggExprToVarExpr = new HashMap<ILogicalExpression, ILogicalExpression>();
        boolean changed = this.collectVarsBottomUp(opRef, context, nspAggVars, nspWithAgg, nspAggVarToPlanIndex, aggExprToVarExpr);
        if (changed) {
            this.removeRedundantListifies(nspAggVars, nspWithAgg, nspAggVarToPlanIndex);
        }
        return changed;
    }

    private void removeRedundantListifies(Map<LogicalVariable, Integer> nspAggVars, Map<LogicalVariable, AbstractOperatorWithNestedPlans> nspWithAgg, Map<LogicalVariable, Integer> nspAggVarToPlanIndex) throws AlgebricksException {
        ArrayList<Pair> removeList = new ArrayList<Pair>();
        for (Map.Entry<LogicalVariable, Integer> aggVarEntry : nspAggVars.entrySet()) {
            AbstractOperatorWithNestedPlans nspOp;
            AggregateOperator aggOp;
            int pos;
            LogicalVariable logicalVariable = aggVarEntry.getKey();
            int occurs = aggVarEntry.getValue();
            if (occurs != 0 || (pos = (aggOp = (AggregateOperator)((Mutable)((ILogicalPlan)(nspOp = nspWithAgg.get(logicalVariable)).getNestedPlans().get(nspAggVarToPlanIndex.get(logicalVariable))).getRoots().get(0)).getValue()).getVariables().indexOf(logicalVariable)) < 0) continue;
            aggOp.getVariables().remove(pos);
            aggOp.getExpressions().remove(pos);
            ArrayList producedVarsAtAgg = new ArrayList();
            VariableUtilities.getProducedVariablesInDescendantsAndSelf((ILogicalOperator)aggOp, producedVarsAtAgg);
            if (!producedVarsAtAgg.isEmpty()) continue;
            removeList.add(new Pair((Object)nspOp, (Object)nspAggVarToPlanIndex.get(logicalVariable)));
        }
        HashMap nspToSubplanListMap = new HashMap();
        for (Pair pair : removeList) {
            List<ILogicalPlan> subplans;
            AbstractOperatorWithNestedPlans groupByOperator = (AbstractOperatorWithNestedPlans)pair.first;
            ILogicalPlan subplan = (ILogicalPlan)((AbstractOperatorWithNestedPlans)pair.first).getNestedPlans().get((Integer)pair.second);
            if (nspToSubplanListMap.containsKey(groupByOperator)) {
                subplans = (List)nspToSubplanListMap.get(groupByOperator);
                subplans.add(subplan);
                continue;
            }
            subplans = new ArrayList();
            subplans.add(subplan);
            nspToSubplanListMap.put(groupByOperator, subplans);
        }
        for (Map.Entry entry : nspToSubplanListMap.entrySet()) {
            ((AbstractOperatorWithNestedPlans)entry.getKey()).getNestedPlans().removeAll((Collection)entry.getValue());
        }
    }

    private boolean collectVarsBottomUp(Mutable<ILogicalOperator> opRef, IOptimizationContext context, Map<LogicalVariable, Integer> nspListifyVarsCount, Map<LogicalVariable, AbstractOperatorWithNestedPlans> nspWithAgg, Map<LogicalVariable, Integer> nspAggVarToPlanIndex, Map<ILogicalExpression, ILogicalExpression> aggregateExprToVarExpr) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1);
        boolean change = false;
        for (Mutable child : op1.getInputs()) {
            if (!this.collectVarsBottomUp((Mutable<ILogicalOperator>)child, context, nspListifyVarsCount, nspWithAgg, nspAggVarToPlanIndex, aggregateExprToVarExpr)) continue;
            change = true;
        }
        HashSet used = new HashSet();
        VariableUtilities.getUsedVariables((ILogicalOperator)op1, used);
        switch (op1.getOperatorTag()) {
            case ASSIGN: 
            case SELECT: {
                boolean found = false;
                for (Object v : used) {
                    if (nspListifyVarsCount.get(v) == null) continue;
                    found = true;
                    break;
                }
                if (!found) break;
                if (op1.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                    AssignOperator assign = (AssignOperator)op1;
                    for (Mutable exprRef : assign.getExpressions()) {
                        Pair<Boolean, ILogicalExpression> p = this.extractAggFunctionsFromExpression((Mutable<ILogicalExpression>)exprRef, nspWithAgg, aggregateExprToVarExpr, context);
                        if (!((Boolean)p.first).booleanValue()) continue;
                        change = true;
                        exprRef.setValue(p.second);
                    }
                }
                if (op1.getOperatorTag() == LogicalOperatorTag.SELECT) {
                    SelectOperator select = (SelectOperator)op1;
                    Mutable exprRef = select.getCondition();
                    Pair<Boolean, ILogicalExpression> p = this.extractAggFunctionsFromExpression((Mutable<ILogicalExpression>)exprRef, nspWithAgg, aggregateExprToVarExpr, context);
                    if (((Boolean)p.first).booleanValue()) {
                        change = true;
                        exprRef.setValue(p.second);
                    }
                }
                used.clear();
                VariableUtilities.getUsedVariables((ILogicalOperator)op1, used);
                for (Object v : used) {
                    Integer m = nspListifyVarsCount.get(v);
                    if (m == null) continue;
                    nspListifyVarsCount.put((LogicalVariable)v, m + 1);
                }
                break;
            }
            case SUBPLAN: {
                for (LogicalVariable v : used) {
                    Integer m = nspListifyVarsCount.get(v);
                    if (m == null) continue;
                    AbstractOperatorWithNestedPlans nspOp = nspWithAgg.get(v);
                    if (this.pushSubplanAsAggIntoNestedSubplan(opRef, nspOp, v, nspListifyVarsCount, nspWithAgg, nspAggVarToPlanIndex, context)) {
                        change = true;
                        continue;
                    }
                    nspListifyVarsCount.put(v, m + 1);
                }
                if (change) break;
                this.collectAggregateVars(nspListifyVarsCount, nspWithAgg, nspAggVarToPlanIndex, (AbstractOperatorWithNestedPlans)op1);
                break;
            }
            case GROUP: {
                this.collectAggregateVars(nspListifyVarsCount, nspWithAgg, nspAggVarToPlanIndex, (AbstractOperatorWithNestedPlans)op1);
                break;
            }
            default: {
                for (LogicalVariable v : used) {
                    Integer m = nspListifyVarsCount.get(v);
                    if (m == null) continue;
                    nspListifyVarsCount.put(v, m + 1);
                }
            }
        }
        return change;
    }

    private void collectAggregateVars(Map<LogicalVariable, Integer> nspListifyVarsCount, Map<LogicalVariable, AbstractOperatorWithNestedPlans> nspWithAgg, Map<LogicalVariable, Integer> nspAggVarToPlanIndex, AbstractOperatorWithNestedPlans op) {
        List<LogicalVariable> vars = this.collectOneVarPerAggFromOpWithNestedPlans(op);
        for (int i = 0; i < vars.size(); ++i) {
            LogicalVariable v = vars.get(i);
            if (v == null) continue;
            nspListifyVarsCount.put(v, 0);
            nspAggVarToPlanIndex.put(v, i);
            nspWithAgg.put(v, op);
        }
    }

    private List<LogicalVariable> collectOneVarPerAggFromOpWithNestedPlans(AbstractOperatorWithNestedPlans op) {
        List nPlans = op.getNestedPlans();
        if (nPlans == null || nPlans.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LogicalVariable> aggVars = new ArrayList<LogicalVariable>();
        for (int i = 0; i < nPlans.size(); ++i) {
            AbstractFunctionCallExpression fceAgg;
            ILogicalExpression expr;
            AggregateOperator agg;
            AbstractLogicalOperator topOp = (AbstractLogicalOperator)((Mutable)((ILogicalPlan)nPlans.get(i)).getRoots().get(0)).getValue();
            if (topOp.getOperatorTag() != LogicalOperatorTag.AGGREGATE || (agg = (AggregateOperator)topOp).getVariables().size() != 1 || (expr = (ILogicalExpression)((Mutable)agg.getExpressions().get(0)).getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || (fceAgg = (AbstractFunctionCallExpression)expr).getFunctionIdentifier() != BuiltinFunctions.LISTIFY) continue;
            aggVars.add((LogicalVariable)agg.getVariables().get(0));
        }
        return aggVars;
    }

    private Pair<Boolean, ILogicalExpression> extractAggFunctionsFromExpression(Mutable<ILogicalExpression> exprRef, Map<LogicalVariable, AbstractOperatorWithNestedPlans> nspWithAgg, Map<ILogicalExpression, ILogicalExpression> aggregateExprToVarExpr, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        switch (expr.getExpressionTag()) {
            case FUNCTION_CALL: {
                LogicalVariable argVar;
                AbstractOperatorWithNestedPlans nspOp;
                ILogicalExpression a1;
                AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr;
                FunctionIdentifier fi = BuiltinFunctions.getAggregateFunction((FunctionIdentifier)fce.getFunctionIdentifier());
                if (fi != null && (a1 = (ILogicalExpression)((Mutable)fce.getArguments().get(0)).getValue()).getExpressionTag() == LogicalExpressionTag.VARIABLE && (nspOp = nspWithAgg.get(argVar = ((VariableReferenceExpression)a1).getVariableReference())) != null) {
                    if (!aggregateExprToVarExpr.containsKey(expr)) {
                        LogicalVariable newVar = context.newVar();
                        AggregateFunctionCallExpression aggFun = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)fi, (List)fce.getArguments());
                        this.rewriteAggregateInNestedSubplan(argVar, nspOp, aggFun, newVar, context);
                        VariableReferenceExpression newVarExpr = new VariableReferenceExpression(newVar);
                        aggregateExprToVarExpr.put(expr, (ILogicalExpression)newVarExpr);
                        return new Pair((Object)Boolean.TRUE, (Object)newVarExpr);
                    }
                    ILogicalExpression varExpr = aggregateExprToVarExpr.get(expr);
                    return new Pair((Object)Boolean.TRUE, (Object)varExpr);
                }
                boolean change = false;
                for (Mutable a : fce.getArguments()) {
                    Pair<Boolean, ILogicalExpression> aggArg = this.extractAggFunctionsFromExpression((Mutable<ILogicalExpression>)a, nspWithAgg, aggregateExprToVarExpr, context);
                    if (!((Boolean)aggArg.first).booleanValue()) continue;
                    a.setValue(aggArg.second);
                    change = true;
                }
                return new Pair((Object)change, (Object)fce);
            }
            case VARIABLE: 
            case CONSTANT: {
                return new Pair((Object)Boolean.FALSE, (Object)expr);
            }
        }
        throw new IllegalArgumentException();
    }

    private void rewriteAggregateInNestedSubplan(LogicalVariable oldAggVar, AbstractOperatorWithNestedPlans nspOp, AggregateFunctionCallExpression aggFun, LogicalVariable newAggVar, IOptimizationContext context) throws AlgebricksException {
        block0: for (int j = 0; j < nspOp.getNestedPlans().size(); ++j) {
            AggregateOperator aggOp = (AggregateOperator)((Mutable)((ILogicalPlan)nspOp.getNestedPlans().get(j)).getRoots().get(0)).getValue();
            int n = aggOp.getVariables().size();
            for (int i = 0; i < n; ++i) {
                LogicalVariable v = (LogicalVariable)aggOp.getVariables().get(i);
                if (!v.equals((Object)oldAggVar)) continue;
                AbstractFunctionCallExpression oldAggExpr = (AbstractFunctionCallExpression)((Mutable)aggOp.getExpressions().get(i)).getValue();
                AggregateFunctionCallExpression newAggFun = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)aggFun.getFunctionIdentifier(), new ArrayList());
                for (Mutable arg : oldAggExpr.getArguments()) {
                    ILogicalExpression cloned = ((ILogicalExpression)arg.getValue()).cloneExpression();
                    newAggFun.getArguments().add(new MutableObject((Object)cloned));
                }
                aggOp.getVariables().add(newAggVar);
                aggOp.getExpressions().add(new MutableObject((Object)newAggFun));
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)aggOp);
                continue block0;
            }
        }
    }

    private boolean pushSubplanAsAggIntoNestedSubplan(Mutable<ILogicalOperator> subplanOpRef, AbstractOperatorWithNestedPlans nspOp, LogicalVariable varFromNestedAgg, Map<LogicalVariable, Integer> nspAggVars, Map<LogicalVariable, AbstractOperatorWithNestedPlans> nspWithAgg, Map<LogicalVariable, Integer> nspAggVarToPlanIndex, IOptimizationContext context) throws AlgebricksException {
        SubplanOperator subplan = (SubplanOperator)subplanOpRef.getValue();
        HashSet freeVars = new HashSet();
        OperatorPropertiesUtil.getFreeVariablesInSubplans((AbstractOperatorWithNestedPlans)subplan, freeVars);
        for (LogicalVariable vFree : freeVars) {
            if (vFree.equals((Object)varFromNestedAgg)) continue;
            return false;
        }
        List plans = subplan.getNestedPlans();
        if (plans.size() > 1) {
            return false;
        }
        ILogicalPlan p = (ILogicalPlan)plans.get(0);
        if (p.getRoots().size() > 1) {
            return false;
        }
        Mutable opRef = (Mutable)p.getRoots().get(0);
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            return false;
        }
        AggregateOperator aggInSubplanOp = (AggregateOperator)op;
        LogicalVariable unnestVar = null;
        boolean pushableNestedSubplan = false;
        block5: while (op.getInputs().size() == 1) {
            opRef = (Mutable)op.getInputs().get(0);
            op = (AbstractLogicalOperator)opRef.getValue();
            switch (op.getOperatorTag()) {
                case ASSIGN: {
                    continue block5;
                }
                case UNNEST: {
                    UnnestOperator unnest = (UnnestOperator)op;
                    if (unnest.getPositionalVariable() != null) {
                        return false;
                    }
                    ILogicalExpression expr = (ILogicalExpression)unnest.getExpressionRef().getValue();
                    if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                        return false;
                    }
                    AbstractFunctionCallExpression fun = (AbstractFunctionCallExpression)expr;
                    if (fun.getFunctionIdentifier() != BuiltinFunctions.SCAN_COLLECTION) {
                        return false;
                    }
                    ILogicalExpression arg0 = (ILogicalExpression)((Mutable)fun.getArguments().get(0)).getValue();
                    if (arg0.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                        return false;
                    }
                    VariableReferenceExpression varExpr = (VariableReferenceExpression)arg0;
                    if (!varExpr.getVariableReference().equals((Object)varFromNestedAgg)) {
                        return false;
                    }
                    opRef = (Mutable)op.getInputs().get(0);
                    if ((op = (AbstractLogicalOperator)opRef.getValue()).getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE) {
                        return false;
                    }
                    pushableNestedSubplan = true;
                    unnestVar = unnest.getVariable();
                    continue block5;
                }
            }
            return false;
        }
        if (!pushableNestedSubplan) {
            return false;
        }
        for (int i = 0; i < nspOp.getNestedPlans().size(); ++i) {
            Mutable nspAggRef;
            block20: {
                Mutable opRef2InSubplan;
                AbstractLogicalOperator op2InSubplan;
                nspAggRef = (Mutable)((ILogicalPlan)nspOp.getNestedPlans().get(i)).getRoots().get(0);
                AggregateOperator nspAgg = (AggregateOperator)nspAggRef.getValue();
                Mutable nspAggChildRef = (Mutable)nspAgg.getInputs().get(0);
                LogicalVariable listifyVar = this.findListifiedVariable(nspAgg, varFromNestedAgg);
                if (listifyVar == null) continue;
                OperatorManipulationUtil.substituteVarRec((AbstractLogicalOperator)aggInSubplanOp, unnestVar, (LogicalVariable)listifyVar, (boolean)true, (ITypingContext)context);
                nspAgg.getVariables().addAll(aggInSubplanOp.getVariables());
                nspAgg.getExpressions().addAll(aggInSubplanOp.getExpressions());
                for (LogicalVariable v : aggInSubplanOp.getVariables()) {
                    nspWithAgg.put(v, nspOp);
                    nspAggVars.put(v, 0);
                    nspAggVarToPlanIndex.put(v, i);
                }
                Mutable opRef1InSubplan = (Mutable)aggInSubplanOp.getInputs().get(0);
                if (!((ILogicalOperator)opRef1InSubplan.getValue()).getInputs().isEmpty() && (op2InSubplan = (AbstractLogicalOperator)(opRef2InSubplan = (Mutable)((ILogicalOperator)opRef1InSubplan.getValue()).getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE) {
                    List nspInpList = nspAgg.getInputs();
                    nspInpList.clear();
                    nspInpList.add(opRef1InSubplan);
                    do {
                        if ((op2InSubplan = (AbstractLogicalOperator)(opRef2InSubplan = (Mutable)((ILogicalOperator)opRef1InSubplan.getValue()).getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.UNNEST) continue;
                        List opInpList = ((ILogicalOperator)opRef1InSubplan.getValue()).getInputs();
                        opInpList.clear();
                        opInpList.add(nspAggChildRef);
                        break block20;
                    } while (!((ILogicalOperator)(opRef1InSubplan = opRef2InSubplan).getValue()).getInputs().isEmpty());
                    throw new IllegalStateException("PushAggregateIntoNestedSubplanRule: could not find UNNEST.");
                }
            }
            subplanOpRef.setValue(((Mutable)subplan.getInputs().get(0)).getValue());
            OperatorPropertiesUtil.typeOpRec((Mutable)nspAggRef, (IOptimizationContext)context);
        }
        return true;
    }

    private LogicalVariable findListifiedVariable(AggregateOperator nspAgg, LogicalVariable varFromNestedAgg) {
        int n = nspAgg.getVariables().size();
        for (int i = 0; i < n; ++i) {
            ILogicalExpression argExpr;
            AbstractFunctionCallExpression fce;
            if (!((LogicalVariable)nspAgg.getVariables().get(i)).equals((Object)varFromNestedAgg) || !(fce = (AbstractFunctionCallExpression)((Mutable)nspAgg.getExpressions().get(i)).getValue()).getFunctionIdentifier().equals((Object)BuiltinFunctions.LISTIFY) || (argExpr = (ILogicalExpression)((Mutable)fce.getArguments().get(0)).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            return ((VariableReferenceExpression)argExpr).getVariableReference();
        }
        return null;
    }
}

