/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.hdfs2.dataflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import org.apache.hyracks.hdfs.ContextFactory;
import org.apache.hyracks.hdfs.api.IKeyValueParser;
import org.apache.hyracks.hdfs.api.IKeyValueParserFactory;
import org.apache.hyracks.hdfs2.dataflow.ConfFactory;
import org.apache.hyracks.hdfs2.dataflow.FileSplitsFactory;

public class HDFSReadOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final ConfFactory confFactory;
    private final FileSplitsFactory splitsFactory;
    private final String[] scheduledLocations;
    private final IKeyValueParserFactory tupleParserFactory;
    private final boolean[] executed;

    public HDFSReadOperatorDescriptor(JobSpecification spec, RecordDescriptor rd, Job conf, List<InputSplit> splits, String[] scheduledLocations, IKeyValueParserFactory tupleParserFactory) throws HyracksException {
        super((IOperatorDescriptorRegistry)spec, 0, 1);
        try {
            ArrayList<FileSplit> fileSplits = new ArrayList<FileSplit>();
            for (int i = 0; i < splits.size(); ++i) {
                fileSplits.add((FileSplit)splits.get(i));
            }
            this.splitsFactory = new FileSplitsFactory(fileSplits);
            this.confFactory = new ConfFactory(conf);
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
        this.scheduledLocations = scheduledLocations;
        this.executed = new boolean[scheduledLocations.length];
        Arrays.fill(this.executed, false);
        this.tupleParserFactory = tupleParserFactory;
        this.outRecDescs[0] = rd;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        final List<FileSplit> inputSplits = this.splitsFactory.getSplits();
        return new AbstractUnaryOutputSourceOperatorNodePushable(){
            private String nodeName;
            private ContextFactory ctxFactory;
            {
                this.nodeName = ctx.getJobletContext().getServiceContext().getNodeId();
                this.ctxFactory = new ContextFactory();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void initialize() throws HyracksDataException {
                ClassLoader ctxCL = Thread.currentThread().getContextClassLoader();
                try {
                    this.writer.open();
                    Thread.currentThread().setContextClassLoader(ctx.getJobletContext().getClassLoader());
                    Job job = HDFSReadOperatorDescriptor.this.confFactory.getConf();
                    job.getConfiguration().setClassLoader(ctx.getJobletContext().getClassLoader());
                    IKeyValueParser<Object, Object> parser = HDFSReadOperatorDescriptor.this.tupleParserFactory.createKeyValueParser(ctx);
                    InputFormat inputFormat = (InputFormat)ReflectionUtils.newInstance((Class)job.getInputFormatClass(), (Configuration)job.getConfiguration());
                    int size = inputSplits.size();
                    for (int i = 0; i < size; ++i) {
                        if (!HDFSReadOperatorDescriptor.this.scheduledLocations[i].equals(this.nodeName)) continue;
                        boolean[] blArray = HDFSReadOperatorDescriptor.this.executed;
                        synchronized (blArray) {
                            if (HDFSReadOperatorDescriptor.this.executed[i]) {
                                continue;
                            }
                            ((HDFSReadOperatorDescriptor)HDFSReadOperatorDescriptor.this).executed[i] = true;
                        }
                        TaskAttemptContext context = this.ctxFactory.createContext(job.getConfiguration(), i);
                        context.getConfiguration().setClassLoader(ctx.getJobletContext().getClassLoader());
                        RecordReader reader = inputFormat.createRecordReader((InputSplit)inputSplits.get(i), context);
                        reader.initialize((InputSplit)inputSplits.get(i), context);
                        while (reader.nextKeyValue()) {
                            parser.parse(reader.getCurrentKey(), reader.getCurrentValue(), this.writer, ((FileSplit)inputSplits.get(i)).toString());
                        }
                    }
                    parser.close(this.writer);
                }
                catch (Throwable th) {
                    this.writer.fail();
                    throw new HyracksDataException(th);
                }
                finally {
                    this.writer.close();
                    Thread.currentThread().setContextClassLoader(ctxCL);
                }
            }
        };
    }
}

