/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.management;

import org.apache.asterix.event.schema.pattern.Value;

public class ValueType {
    private Value value;
    private Type type;

    public ValueType(Value value) {
        this.value = value;
        if (value.getAbsvalue() != null) {
            this.type = Type.ABS;
        } else if (value.getRandom() != null) {
            if (value.getRandom().getMinmax() != null) {
                this.type = Type.RANDOM_MIN_MAX;
            } else if (value.getRandom().getRange() != null) {
                this.type = Type.RANDOM_RANGE;
            } else {
                throw new IllegalStateException("Incorrect value type");
            }
        }
    }

    public int getMin() {
        switch (this.type) {
            case RANDOM_MIN_MAX: {
                return Integer.parseInt(this.value.getRandom().getMinmax().getMin());
            }
        }
        throw new IllegalStateException("");
    }

    public int getMax() {
        switch (this.type) {
            case RANDOM_MIN_MAX: {
                return Integer.parseInt(this.value.getRandom().getMinmax().getMax());
            }
        }
        throw new IllegalStateException("");
    }

    public String[] getRangeSet() {
        switch (this.type) {
            case RANDOM_RANGE: {
                return this.value.getRandom().getRange().getSet().split(" ");
            }
        }
        throw new IllegalStateException("");
    }

    public String[] getRangeExcluded() {
        switch (this.type) {
            case RANDOM_RANGE: {
                String exl = this.value.getRandom().getRange().getExclude();
                return exl != null ? exl.split(" ") : null;
            }
        }
        throw new IllegalStateException("");
    }

    public String getAbsoluteValue() {
        switch (this.type) {
            case ABS: {
                return this.value.getAbsvalue();
            }
        }
        throw new IllegalStateException("");
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        ABS,
        RANDOM_RANGE,
        RANDOM_MIN_MAX;

    }
}

