/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.management;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.asterix.event.driver.EventDriver;
import org.apache.asterix.event.management.EventTask;
import org.apache.asterix.event.management.EventTaskReport;
import org.apache.asterix.event.management.IOutputHandler;
import org.apache.asterix.event.management.IPatternListener;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.event.schema.event.Events;
import org.apache.asterix.event.schema.pattern.Event;
import org.apache.asterix.event.schema.pattern.Nodeid;
import org.apache.asterix.event.schema.pattern.Pattern;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.schema.pattern.Value;
import org.apache.asterix.installer.schema.conf.Configuration;

public class AsterixEventServiceClient {
    private static final Logger LOGGER = Logger.getLogger(AsterixEventServiceClient.class.getName());
    private EventTask[] tasks;
    private boolean dryRun = false;
    private LinkedBlockingQueue<EventTaskReport> msgInbox = new LinkedBlockingQueue();
    private AtomicInteger pendingTasks = new AtomicInteger(0);
    private final Cluster cluster;
    private IPatternListener listener;
    private IOutputHandler outputHandler;
    private Events events;
    private String eventsHomeDir;
    private Configuration configuration;

    public AsterixEventServiceClient(Configuration configuration, String eventsHomeDir, Cluster cluster, boolean transferArtifacts, boolean dryRun, IOutputHandler outputHandler) throws Exception {
        this.eventsHomeDir = eventsHomeDir;
        this.events = this.initializeEvents();
        this.cluster = cluster;
        this.dryRun = dryRun;
        this.configuration = configuration;
        this.outputHandler = outputHandler;
        if (!dryRun && transferArtifacts) {
            this.initializeCluster(this.getEventsDir());
        }
    }

    public void submit(Patterns patterns) throws Exception {
        if (patterns.getPattern().isEmpty()) {
            return;
        }
        this.initTasks(patterns);
        try {
            this.waitForCompletion();
        }
        catch (InterruptedException ie) {
            LOGGER.info("Interrupted exception :" + ie);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void submit(Patterns patterns, IPatternListener listener) throws Exception {
        this.listener = listener;
        this.initTasks(patterns);
    }

    private void initTasks(Patterns patterns) {
        this.tasks = new EventTask[patterns.getPattern().size()];
        this.pendingTasks.set(this.tasks.length);
        int index = 0;
        for (Pattern pattern : patterns.getPattern()) {
            this.tasks[index] = new EventTask(pattern, this);
            this.tasks[index].start();
            ++index;
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public Events getEvents() {
        return this.events;
    }

    public String getEventsDir() {
        return this.eventsHomeDir + File.separator + "events";
    }

    public synchronized void notifyCompletion(EventTaskReport report) {
        if (report.isSuccess()) {
            if (this.listener != null) {
                this.pendingTasks.decrementAndGet();
                this.listener.eventCompleted(report);
                if (this.pendingTasks.get() == 0) {
                    this.listener.jobCompleted();
                }
            } else {
                try {
                    this.msgInbox.put(report);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            for (EventTask t : this.tasks) {
                if (t.getState() != EventTask.State.INITIALIZED && t.getState() != EventTask.State.IN_PROGRESS) continue;
                t.cancel();
            }
            if (this.listener != null) {
                this.listener.jobFailed(report);
            } else {
                try {
                    this.msgInbox.put(report);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void waitForCompletion() throws Exception {
        block1: {
            EventTaskReport report;
            while ((report = this.msgInbox.take()).isSuccess()) {
                if (this.pendingTasks.decrementAndGet() != 0) continue;
                break block1;
            }
            throw report.getException();
        }
    }

    private void initializeCluster(String eventsDir) throws Exception {
        Patterns patterns = this.initPattern(eventsDir);
        this.submit(patterns);
    }

    private Patterns initPattern(String eventsDir) throws Exception {
        Nodeid nodeid = new Nodeid(new Value(null, EventDriver.CLIENT_NODE.getId()));
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        String workingDir = this.cluster.getWorkingDir().getDir();
        String username = this.cluster.getUsername() == null ? System.getProperty("user.name") : this.cluster.getUsername();
        patternList.add(this.getDirectoryTransferPattern(username, eventsDir, nodeid, this.cluster.getMasterNode().getClusterIp(), workingDir));
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        String outputPathDir = System.getProperty("java.io.tmpdir") + File.separator + "conf-" + System.getProperty("user.name");
        new File(outputPathDir).mkdirs();
        String outputPath = outputPathDir + File.separator + "configuration.xml";
        marshaller.marshal((Object)this.configuration, (OutputStream)new FileOutputStream(outputPath));
        patternList.add(this.getFileTransferPattern(username, outputPath, nodeid, this.cluster.getMasterNode().getClusterIp(), workingDir));
        if (!this.cluster.getWorkingDir().isNFS()) {
            for (Node node : this.cluster.getNode()) {
                patternList.add(this.getDirectoryTransferPattern(username, eventsDir, nodeid, node.getClusterIp(), workingDir));
            }
        }
        return new Patterns(patternList);
    }

    private Pattern getDirectoryTransferPattern(String username, String src, Nodeid srcNode, String destNodeIp, String destDir) {
        String pargs = username + " " + src + " " + destNodeIp + " " + destDir;
        Event event = new Event("directory_transfer", srcNode, pargs);
        return new Pattern(null, 1, null, event);
    }

    private Pattern getFileTransferPattern(String username, String src, Nodeid srcNode, String destNodeIp, String destDir) {
        String pargs = username + " " + src + " " + destNodeIp + " " + destDir;
        Event event = new Event("file_transfer", srcNode, pargs);
        return new Pattern(null, 1, null, event);
    }

    public IOutputHandler getErrorHandler() {
        return this.outputHandler;
    }

    private Events initializeEvents() throws JAXBException, FileNotFoundException {
        File file = new File(this.getEventsDir() + File.separator + "events.xml");
        JAXBContext eventCtx = JAXBContext.newInstance((Class[])new Class[]{Events.class});
        Unmarshaller unmarshaller = eventCtx.createUnmarshaller();
        this.events = (Events)unmarshaller.unmarshal(file);
        return this.events;
    }

    public String getEventsHomeDir() {
        return this.eventsHomeDir;
    }
}

