/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.error;

import java.io.File;
import java.util.ArrayList;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.model.AsterixRuntimeState;
import org.apache.asterix.event.model.ProcessInfo;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;

public class VerificationUtil {
    private static final String VERIFY_SCRIPT_PATH = AsterixEventService.getEventHome() + File.separator + "scripts" + File.separator + "verify.sh";

    public static AsterixRuntimeState getAsterixRuntimeState(AsterixInstance instance) throws Exception {
        Cluster cluster = instance.getCluster();
        ArrayList<String> args = new ArrayList<String>();
        args.add(instance.getName());
        args.add(instance.getCluster().getMasterNode().getClusterIp());
        for (Node node : cluster.getNode()) {
            args.add(node.getClusterIp());
            args.add(instance.getName() + "_" + node.getId());
        }
        Thread.sleep(2000L);
        String output = AsterixEventServiceUtil.executeLocalScript(VERIFY_SCRIPT_PATH, args);
        boolean ccRunning = true;
        ArrayList<String> failedNCs = new ArrayList<String>();
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        for (String line : output.split("\n")) {
            String nodeid = null;
            String[] infoFields = line.split(":");
            try {
                int pid = Integer.parseInt(infoFields[3]);
                nodeid = infoFields[0].equals("NC") ? infoFields[2].split("_")[1] : instance.getCluster().getMasterNode().getId();
                processes.add(new ProcessInfo(infoFields[0], infoFields[1], nodeid, pid));
            }
            catch (Exception e) {
                if (infoFields[0].equalsIgnoreCase("CC")) {
                    ccRunning = false;
                    continue;
                }
                failedNCs.add(infoFields[1]);
            }
        }
        return new AsterixRuntimeState(processes, failedNCs, ccRunning);
    }

    public static void updateInstanceWithRuntimeDescription(AsterixInstance instance, AsterixRuntimeState state, boolean expectedRunning) {
        StringBuilder summary = new StringBuilder();
        if (expectedRunning) {
            if (!state.isCcRunning()) {
                summary.append("Cluster Controller not running at " + instance.getCluster().getMasterNode().getId() + "\n");
                instance.setState(AsterixInstance.State.UNUSABLE);
            }
            if (state.getFailedNCs() != null && !state.getFailedNCs().isEmpty()) {
                summary.append("Node Controller not running at the following nodes\n");
                for (String failedNC : state.getFailedNCs()) {
                    summary.append(failedNC + "\n");
                }
            }
            if (!instance.getState().equals((Object)AsterixInstance.State.UNUSABLE)) {
                instance.setState(AsterixInstance.State.ACTIVE);
            }
        } else if (state.getProcesses() != null && state.getProcesses().size() > 0) {
            summary.append("Following process still running \n");
            for (ProcessInfo pInfo : state.getProcesses()) {
                summary.append(pInfo + "\n");
            }
        }
        state.setSummary(summary.toString());
        instance.setAsterixRuntimeStates(state);
    }

    public static void verifyBackupRestoreConfiguration(String hdfsUrl, String hadoopVersion, String hdfsBackupDir) throws Exception {
        StringBuilder errorCheck = new StringBuilder();
        if (hdfsUrl == null || hdfsUrl.length() == 0) {
            errorCheck.append("\n HDFS Url not configured");
        }
        if (hadoopVersion == null || hadoopVersion.length() == 0) {
            errorCheck.append("\n HDFS version not configured");
        }
        if (hdfsBackupDir == null || hdfsBackupDir.length() == 0) {
            errorCheck.append("\n HDFS backup directory not configured");
        }
        if (errorCheck.length() > 0) {
            throw new Exception("Incomplete hdfs configuration" + errorCheck);
        }
    }
}

