/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import java.io.IOException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class TaskQueue<E> {
    private static final AtomicReferenceFieldUpdater<QueueMonitor, Boolean> MONITOR = AtomicReferenceFieldUpdater.newUpdater(QueueMonitor.class, Boolean.class, "invalid");
    private final Queue<E> queue;
    private final AtomicReference<E> currentElement;
    private final AtomicInteger spaceInBytes = new AtomicInteger();
    protected final Queue<QueueMonitor> monitorQueue;

    protected TaskQueue() {
        this.currentElement = new AtomicReference();
        this.queue = new ConcurrentLinkedQueue();
        this.monitorQueue = new ConcurrentLinkedQueue<QueueMonitor>();
    }

    public static <E> TaskQueue<E> createTaskQueue() {
        return new TaskQueue<E>();
    }

    public int reserveSpace(int amount) {
        return this.spaceInBytes.addAndGet(amount);
    }

    public int releaseSpace(int amount) {
        return this.spaceInBytes.addAndGet(-amount);
    }

    public int releaseSpaceAndNotify(int amount) throws IOException {
        int space = this.releaseSpace(amount);
        this.doNotify();
        return space;
    }

    public int spaceInBytes() {
        return this.spaceInBytes.get();
    }

    public E obtainCurrentElement() {
        E current = this.currentElement.get();
        return current != null ? current : this.queue.poll();
    }

    public E obtainCurrentElementAndReserve() {
        E current = this.currentElement.getAndSet(null);
        return current != null ? current : (E)this.queue.poll();
    }

    public boolean addQueueMonitor(QueueMonitor monitor) throws IOException {
        if (monitor.shouldNotify()) {
            monitor.onNotify();
            return false;
        }
        this.monitorQueue.offer(monitor);
        return true;
    }

    public void removeQueueMonitor(QueueMonitor monitor) {
        this.monitorQueue.remove(monitor);
    }

    protected void doNotify() throws IOException {
        if (!this.monitorQueue.isEmpty()) {
            Iterator i = this.monitorQueue.iterator();
            while (i.hasNext()) {
                QueueMonitor m = (QueueMonitor)i.next();
                if (!MONITOR.get(m).booleanValue()) {
                    if (!m.shouldNotify() || !MONITOR.compareAndSet(m, Boolean.FALSE, Boolean.TRUE)) continue;
                    m.onNotify();
                    continue;
                }
                i.remove();
            }
        }
    }

    public void setCurrentElement(E task) {
        this.currentElement.set(task);
    }

    public boolean remove(E task) {
        return this.queue.remove(task);
    }

    public void offer(E task) {
        this.queue.offer(task);
    }

    public boolean isEmpty() {
        return this.spaceInBytes.get() == 0;
    }

    public static abstract class QueueMonitor {
        volatile Boolean invalid = Boolean.FALSE;

        public abstract void onNotify() throws IOException;

        public abstract boolean shouldNotify();
    }
}

