/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.Map;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.cc.job.TaskAttempt;
import org.apache.hyracks.control.cc.work.AbstractTaskLifecycleWork;
import org.apache.hyracks.control.common.job.profiling.om.JobProfile;
import org.apache.hyracks.control.common.job.profiling.om.JobletProfile;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;

public class TaskCompleteWork
extends AbstractTaskLifecycleWork {
    private final TaskProfile statistics;

    public TaskCompleteWork(ClusterControllerService ccs, JobId jobId, TaskAttemptId taId, String nodeId, TaskProfile statistics) {
        super(ccs, jobId, taId, nodeId);
        this.statistics = statistics;
    }

    @Override
    protected void performEvent(TaskAttempt ta) {
        try {
            IJobManager jobManager = this.ccs.getJobManager();
            JobRun run = jobManager.get(this.jobId);
            if (this.statistics != null) {
                JobProfile jobProfile = run.getJobProfile();
                Map jobletProfiles = jobProfile.getJobletProfiles();
                JobletProfile jobletProfile = (JobletProfile)jobletProfiles.get(this.nodeId);
                if (jobletProfile == null) {
                    jobletProfile = new JobletProfile(this.nodeId);
                    jobletProfiles.put(this.nodeId, jobletProfile);
                }
                jobletProfile.getTaskProfiles().put(this.taId, this.statistics);
            }
            run.getExecutor().notifyTaskComplete(ta);
        }
        catch (HyracksException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.getName() + ": [" + this.nodeId + "[" + this.jobId + ":" + this.taId + "]";
    }
}

