/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.common.work.AbstractWork;

public class RemoveDeadNodesWork
extends AbstractWork {
    private static Logger LOGGER = Logger.getLogger(RemoveDeadNodesWork.class.getName());
    private final ClusterControllerService ccs;

    public RemoveDeadNodesWork(ClusterControllerService ccs) {
        this.ccs = ccs;
    }

    public void run() {
        try {
            INodeManager nodeManager = this.ccs.getNodeManager();
            Pair<Collection<String>, Collection<JobId>> result = nodeManager.removeDeadNodes();
            Collection deadNodes = (Collection)result.getLeft();
            Collection affectedJobIds = (Collection)result.getRight();
            int size = affectedJobIds.size();
            if (size > 0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Number of affected jobs: " + size);
                }
                IJobManager jobManager = this.ccs.getJobManager();
                for (JobId jobId : affectedJobIds) {
                    JobRun run = jobManager.get(jobId);
                    if (run == null) continue;
                    run.getExecutor().notifyNodeFailures(deadNodes);
                }
            }
            if (!deadNodes.isEmpty()) {
                this.ccs.getContext().notifyNodeFailure(deadNodes);
            }
        }
        catch (HyracksException e) {
            LOGGER.log(Level.WARNING, "Uncaught exception on notifyNodeFailure", e);
        }
    }

    public Level logLevel() {
        return Level.FINE;
    }
}

