/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.logging.Logger;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.work.GetThreadDumpWork;
import org.apache.hyracks.control.common.work.AbstractWork;

public class NotifyThreadDumpResponse
extends AbstractWork {
    private static final Logger LOGGER = Logger.getLogger(NotifyThreadDumpResponse.class.getName());
    private final ClusterControllerService ccs;
    private final String requestId;
    private final String threadDumpJSON;

    public NotifyThreadDumpResponse(ClusterControllerService ccs, String requestId, String threadDumpJSON) {
        this.ccs = ccs;
        this.requestId = requestId;
        this.threadDumpJSON = threadDumpJSON;
    }

    public void run() {
        LOGGER.fine("Delivering thread dump response: " + this.requestId);
        GetThreadDumpWork.ThreadDumpRun threadDumpRun = this.ccs.removeThreadDumpRun(this.requestId);
        if (threadDumpRun == null) {
            LOGGER.warning("Thread dump run " + this.requestId + " not found; discarding reply: " + this.threadDumpJSON);
        } else {
            threadDumpRun.notifyThreadDumpReceived(this.threadDumpJSON);
        }
    }
}

