/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.EnumSet;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.job.IActivityClusterGraphGenerator;
import org.apache.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.application.CCServiceContext;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class JobStartWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final byte[] acggfBytes;
    private final EnumSet<JobFlag> jobFlags;
    private final DeploymentId deploymentId;
    private final JobId jobId;
    private final IResultCallback<JobId> callback;
    private final boolean predestributed;

    public JobStartWork(ClusterControllerService ccs, DeploymentId deploymentId, byte[] acggfBytes, EnumSet<JobFlag> jobFlags, JobId jobId, IResultCallback<JobId> callback, boolean predestributed) {
        this.deploymentId = deploymentId;
        this.jobId = jobId;
        this.ccs = ccs;
        this.acggfBytes = acggfBytes;
        this.jobFlags = jobFlags;
        this.callback = callback;
        this.predestributed = predestributed;
    }

    protected void doRun() throws Exception {
        IJobManager jobManager = this.ccs.getJobManager();
        try {
            JobRun run;
            CCServiceContext ccServiceCtx = this.ccs.getContext();
            if (!this.predestributed) {
                IActivityClusterGraphGeneratorFactory acggf = (IActivityClusterGraphGeneratorFactory)DeploymentUtils.deserialize((byte[])this.acggfBytes, (DeploymentId)this.deploymentId, (IServiceContext)ccServiceCtx);
                IActivityClusterGraphGenerator acgg = acggf.createActivityClusterGraphGenerator(this.jobId, (ICCServiceContext)ccServiceCtx, this.jobFlags);
                run = new JobRun(this.ccs, this.deploymentId, this.jobId, acggf, acgg, this.jobFlags);
            } else {
                run = new JobRun(this.ccs, this.deploymentId, this.jobId, this.jobFlags, this.ccs.getPreDistributedJobStore().getDistributedJobDescriptor(this.jobId));
            }
            jobManager.add(run);
            this.callback.setValue((Object)this.jobId);
        }
        catch (Exception e) {
            this.callback.setException(e);
        }
    }
}

