/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.messages.IMessage;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.application.CCServiceContext;
import org.apache.hyracks.control.cc.work.AbstractHeartbeatWork;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;

public class ApplicationMessageWork
extends AbstractHeartbeatWork {
    private static final Logger LOGGER = Logger.getLogger(ApplicationMessageWork.class.getName());
    private byte[] message;
    private DeploymentId deploymentId;
    private String nodeId;
    private ClusterControllerService ccs;

    public ApplicationMessageWork(ClusterControllerService ccs, byte[] message, DeploymentId deploymentId, String nodeId) {
        super(ccs, nodeId, null);
        this.ccs = ccs;
        this.deploymentId = deploymentId;
        this.nodeId = nodeId;
        this.message = message;
    }

    @Override
    public void runWork() {
        final CCServiceContext ctx = this.ccs.getContext();
        try {
            final IMessage data = (IMessage)DeploymentUtils.deserialize((byte[])this.message, (DeploymentId)this.deploymentId, (IServiceContext)ctx);
            this.ccs.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ctx.getMessageBroker().receivedMessage(data, ApplicationMessageWork.this.nodeId);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error in stats reporting", e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getName() + ": nodeID: " + this.nodeId;
    }
}

