/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.cluster;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.client.NodeStatus;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.resource.NodeCapacity;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.cc.scheduler.IResourceManager;
import org.apache.hyracks.control.common.controllers.CCConfig;

public class NodeManager
implements INodeManager {
    private static final Logger LOGGER = Logger.getLogger(NodeManager.class.getName());
    private final ClusterControllerService ccs;
    private final CCConfig ccConfig;
    private final IResourceManager resourceManager;
    private final Map<String, NodeControllerState> nodeRegistry;
    private final Map<InetAddress, Set<String>> ipAddressNodeNameMap;

    public NodeManager(ClusterControllerService ccs, CCConfig ccConfig, IResourceManager resourceManager) {
        this.ccs = ccs;
        this.ccConfig = ccConfig;
        this.resourceManager = resourceManager;
        this.nodeRegistry = new LinkedHashMap<String, NodeControllerState>();
        this.ipAddressNodeNameMap = new HashMap<InetAddress, Set<String>>();
    }

    @Override
    public Map<InetAddress, Set<String>> getIpAddressNodeNameMap() {
        return Collections.unmodifiableMap(this.ipAddressNodeNameMap);
    }

    @Override
    public Collection<String> getAllNodeIds() {
        return Collections.unmodifiableSet(this.nodeRegistry.keySet());
    }

    @Override
    public Collection<NodeControllerState> getAllNodeControllerStates() {
        return Collections.unmodifiableCollection(this.nodeRegistry.values());
    }

    @Override
    public NodeControllerState getNodeControllerState(String nodeId) {
        return this.nodeRegistry.get(nodeId);
    }

    @Override
    public void addNode(String nodeId, NodeControllerState ncState) throws HyracksException {
        LOGGER.warning("addNode(" + nodeId + ") called");
        if (nodeId == null || ncState == null) {
            throw HyracksException.create((int)8, (Serializable[])new Serializable[0]);
        }
        if (this.nodeRegistry.containsKey(nodeId)) {
            LOGGER.warning("Node with name " + nodeId + " has already registered; failing the node then re-registering.");
            this.removeDeadNode(nodeId);
        }
        LOGGER.warning("adding node to registry");
        this.nodeRegistry.put(nodeId, ncState);
        try {
            InetAddress ipAddress = this.getIpAddress(ncState);
            Set nodes = this.ipAddressNodeNameMap.computeIfAbsent(ipAddress, k -> new HashSet());
            nodes.add(nodeId);
        }
        catch (HyracksException e) {
            this.nodeRegistry.remove(nodeId);
            throw e;
        }
        LOGGER.warning("updating cluster capacity");
        this.resourceManager.update(nodeId, ncState.getCapacity());
    }

    @Override
    public void removeNode(String nodeId) throws HyracksException {
        NodeControllerState ncState = this.nodeRegistry.remove(nodeId);
        this.removeNodeFromIpAddressMap(nodeId, ncState);
        this.resourceManager.update(nodeId, new NodeCapacity(0L, 0));
    }

    @Override
    public Map<String, NodeControllerInfo> getNodeControllerInfoMap() {
        LinkedHashMap<String, NodeControllerInfo> result = new LinkedHashMap<String, NodeControllerInfo>();
        for (Map.Entry<String, NodeControllerState> e : this.nodeRegistry.entrySet()) {
            NodeControllerState ncState = e.getValue();
            result.put(e.getKey(), new NodeControllerInfo(e.getKey(), NodeStatus.ALIVE, ncState.getDataPort(), ncState.getDatasetPort(), ncState.getMessagingPort(), ncState.getCapacity().getCores()));
        }
        return result;
    }

    @Override
    public Pair<Collection<String>, Collection<JobId>> removeDeadNodes() throws HyracksException {
        HashSet<String> deadNodes = new HashSet<String>();
        HashSet<JobId> affectedJobIds = new HashSet<JobId>();
        Iterator<Map.Entry<String, NodeControllerState>> nodeIterator = this.nodeRegistry.entrySet().iterator();
        while (nodeIterator.hasNext()) {
            Map.Entry<String, NodeControllerState> entry = nodeIterator.next();
            String nodeId = entry.getKey();
            NodeControllerState state = entry.getValue();
            if (state.incrementLastHeartbeatDuration() < this.ccConfig.getHeartbeatMaxMisses()) continue;
            deadNodes.add(nodeId);
            affectedJobIds.addAll(state.getActiveJobIds());
            nodeIterator.remove();
            this.removeNodeFromIpAddressMap(nodeId, state);
            this.resourceManager.update(nodeId, new NodeCapacity(0L, 0));
            LOGGER.info(entry.getKey() + " considered dead");
        }
        return Pair.of(deadNodes, affectedJobIds);
    }

    public void removeDeadNode(String nodeId) throws HyracksException {
        NodeControllerState state = this.nodeRegistry.get(nodeId);
        Set<JobId> affectedJobIds = state.getActiveJobIds();
        this.nodeRegistry.remove(nodeId);
        this.removeNodeFromIpAddressMap(nodeId, state);
        this.resourceManager.update(nodeId, new NodeCapacity(0L, 0));
        LOGGER.info(nodeId + " considered dead");
        IJobManager jobManager = this.ccs.getJobManager();
        Set<String> collection = Collections.singleton(nodeId);
        for (JobId jobId : affectedJobIds) {
            JobRun run = jobManager.get(jobId);
            if (run == null) continue;
            run.getExecutor().notifyNodeFailures(collection);
        }
        this.ccs.getContext().notifyNodeFailure(collection);
    }

    @Override
    public void apply(INodeManager.NodeFunction nodeFunction) {
        this.nodeRegistry.forEach(nodeFunction::apply);
    }

    private void removeNodeFromIpAddressMap(String nodeId, NodeControllerState ncState) throws HyracksException {
        InetAddress ipAddress = this.getIpAddress(ncState);
        Set<String> nodes = this.ipAddressNodeNameMap.get(ipAddress);
        if (nodes != null) {
            nodes.remove(nodeId);
            if (nodes.isEmpty()) {
                this.ipAddressNodeNameMap.remove(ipAddress);
            }
        }
    }

    private InetAddress getIpAddress(NodeControllerState ncState) throws HyracksException {
        String ipAddress = ncState.getNCConfig().getDataPublicAddress();
        try {
            return InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            throw HyracksException.create((int)7, (Throwable)e, (Serializable[])new Serializable[]{e.getMessage()});
        }
    }
}

