/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;

public class IoUtil {
    private IoUtil() {
    }

    public static void delete(FileReference fileRef) throws HyracksDataException {
        IoUtil.delete(fileRef.getFile());
    }

    public static void delete(File file) throws HyracksDataException {
        try {
            if (file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
            } else {
                Files.delete(file.toPath());
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create(19, e, new Serializable[]{file.getAbsolutePath()});
        }
    }

    public static void create(FileReference fileRef) throws HyracksDataException {
        if (fileRef.getFile().exists()) {
            throw HyracksDataException.create(82, new Serializable[]{fileRef.getAbsolutePath()});
        }
        fileRef.getFile().getParentFile().mkdirs();
        try {
            if (!fileRef.getFile().createNewFile()) {
                throw HyracksDataException.create(82, new Serializable[]{fileRef.getAbsolutePath()});
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create(67, e, new Serializable[]{fileRef.getAbsolutePath()});
        }
    }
}

