/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hyracks.api.util.ExperimentProfilerUtils;

public class ExecutionTimeProfiler {
    public static final boolean PROFILE_MODE = false;
    private FileOutputStream fos;
    private String filePath;
    private StringBuilder sb;
    private Object lock1 = new Object();
    private HashMap<String, LinkedHashMap<String, String>> spentTimePerJobMap;

    public ExecutionTimeProfiler(String filePath) {
        this.filePath = new String(filePath);
        this.sb = new StringBuilder();
        this.spentTimePerJobMap = new HashMap();
    }

    public void begin() {
        try {
            this.fos = ExperimentProfilerUtils.openOutputFile(this.filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public synchronized void add(String jobSignature, String operatorSignature, String message, boolean flushNeeded) {
        if (!this.spentTimePerJobMap.containsKey(jobSignature)) {
            this.spentTimePerJobMap.put(jobSignature, new LinkedHashMap());
        }
        this.spentTimePerJobMap.get(jobSignature).put(operatorSignature, message);
        if (flushNeeded) {
            this.flush(jobSignature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush(String jobSignature) {
        try {
            Object object = this.lock1;
            synchronized (object) {
                this.sb.append("\n\n");
                for (Map.Entry<String, String> entry : this.spentTimePerJobMap.get(jobSignature).entrySet()) {
                    this.sb.append(entry.getValue());
                }
                this.fos.write(this.sb.toString().getBytes());
                this.fos.flush();
                this.spentTimePerJobMap.get(jobSignature).clear();
                this.sb.setLength(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public void clear() {
        this.spentTimePerJobMap.clear();
        this.sb.setLength(0);
    }

    public void clear(String jobSignature) {
        this.spentTimePerJobMap.get(jobSignature).clear();
        this.sb.setLength(0);
    }

    public synchronized void end() {
        try {
            if (this.fos != null) {
                this.fos.flush();
                this.fos.close();
                this.fos = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }
}

