/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.rewriter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.ActivityCluster;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.ActivityClusterId;
import org.apache.hyracks.api.rewriter.runtime.SuperActivity;

public class ActivityClusterGraphRewriter {
    private static final String ONE_TO_ONE_CONNECTOR = "org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor";

    public void rewrite(ActivityClusterGraph acg) {
        acg.getActivityMap().clear();
        acg.getConnectorMap().clear();
        HashMap<IActivity, SuperActivity> invertedActivitySuperActivityMap = new HashMap<IActivity, SuperActivity>();
        for (Map.Entry<ActivityClusterId, ActivityCluster> entry : acg.getActivityClusterMap().entrySet()) {
            this.rewriteIntraActivityCluster(entry.getValue(), invertedActivitySuperActivityMap);
        }
        for (Map.Entry<ActivityClusterId, ActivityCluster> entry : acg.getActivityClusterMap().entrySet()) {
            this.rewriteInterActivityCluster(entry.getValue(), invertedActivitySuperActivityMap);
        }
        invertedActivitySuperActivityMap.clear();
    }

    private void rewriteInterActivityCluster(ActivityCluster ac, Map<IActivity, SuperActivity> invertedActivitySuperActivityMap) {
        Map<ActivityId, Set<ActivityId>> blocked2BlockerMap = ac.getBlocked2BlockerMap();
        HashMap<ActivityId, ActivityId> invertedAid2SuperAidMap = new HashMap<ActivityId, ActivityId>();
        for (Map.Entry<IActivity, SuperActivity> entry : invertedActivitySuperActivityMap.entrySet()) {
            invertedAid2SuperAidMap.put(entry.getKey().getActivityId(), entry.getValue().getActivityId());
        }
        HashMap<ActivityId, Set> replacedBlocked2BlockerMap = new HashMap<ActivityId, Set>();
        for (Map.Entry<ActivityId, Set<ActivityId>> entry : blocked2BlockerMap.entrySet()) {
            ActivityId blocked = entry.getKey();
            ActivityId replacedBlocked = (ActivityId)invertedAid2SuperAidMap.get(blocked);
            Set<ActivityId> blockers = entry.getValue();
            HashSet replacedBlockers = null;
            if (blockers != null) {
                replacedBlockers = new HashSet();
                for (ActivityId blocker : blockers) {
                    replacedBlockers.add(invertedAid2SuperAidMap.get(blocker));
                    ActivityCluster dependingAc = ac.getActivityClusterGraph().getActivityMap().get(invertedAid2SuperAidMap.get(blocker));
                    if (ac.getDependencies().contains(dependingAc)) continue;
                    ac.getDependencies().add(dependingAc);
                }
            }
            if (replacedBlockers == null) continue;
            Set existingBlockers = (Set)replacedBlocked2BlockerMap.get(replacedBlocked);
            if (existingBlockers == null) {
                replacedBlocked2BlockerMap.put(replacedBlocked, replacedBlockers);
                continue;
            }
            existingBlockers.addAll(replacedBlockers);
            replacedBlocked2BlockerMap.put(replacedBlocked, existingBlockers);
        }
        blocked2BlockerMap.clear();
        blocked2BlockerMap.putAll(replacedBlocked2BlockerMap);
    }

    private void rewriteIntraActivityCluster(ActivityCluster ac, Map<IActivity, SuperActivity> invertedActivitySuperActivityMap) {
        Map<ActivityId, IActivity> activities = ac.getActivityMap();
        Map<ActivityId, List<IConnectorDescriptor>> activityInputMap = ac.getActivityInputMap();
        Map<ActivityId, List<IConnectorDescriptor>> activityOutputMap = ac.getActivityOutputMap();
        Map<ConnectorDescriptorId, Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>> connectorActivityMap = ac.getConnectorActivityMap();
        ActivityClusterGraph acg = ac.getActivityClusterGraph();
        HashMap<ActivityId, IActivity> startActivities = new HashMap<ActivityId, IActivity>();
        HashMap<ActivityId, SuperActivity> superActivities = new HashMap<ActivityId, SuperActivity>();
        HashMap<ActivityId, Queue<IActivity>> toBeExpendedMap = new HashMap<ActivityId, Queue<IActivity>>();
        for (Map.Entry<ActivityId, IActivity> entry : activities.entrySet()) {
            ActivityId activityId = entry.getKey();
            IActivity activity = entry.getValue();
            if (activityInputMap.get(activityId) != null) continue;
            startActivities.put(activityId, activity);
            this.createNewSuperActivity(ac, superActivities, toBeExpendedMap, invertedActivitySuperActivityMap, activityId, activity);
        }
        HashMap<ActivityId, SuperActivity> clonedSuperActivities = new HashMap<ActivityId, SuperActivity>();
        while (toBeExpendedMap.size() > 0) {
            clonedSuperActivities.clear();
            clonedSuperActivities.putAll(superActivities);
            for (Map.Entry entry : clonedSuperActivities.entrySet()) {
                Object toBeExpended;
                ActivityId superActivityId = (ActivityId)entry.getKey();
                SuperActivity superActivity = (SuperActivity)entry.getValue();
                if (superActivities.get(superActivityId) == null || (toBeExpended = (Queue)toBeExpendedMap.get(superActivityId)) == null) continue;
                IActivity expendingActivity = (IActivity)toBeExpended.poll();
                List<IConnectorDescriptor> list = activityOutputMap.get(expendingActivity.getActivityId());
                if (list != null) {
                    for (IConnectorDescriptor outputConn : list) {
                        Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>> endPoints = connectorActivityMap.get(outputConn.getConnectorId());
                        IActivity newActivity = (IActivity)((Pair)endPoints.getRight()).getLeft();
                        SuperActivity existingSuperActivity = invertedActivitySuperActivityMap.get(newActivity);
                        if (outputConn.getClass().getName().contains(ONE_TO_ONE_CONNECTOR)) {
                            if (existingSuperActivity == null) {
                                superActivity.addActivity(newActivity);
                                toBeExpended.add(newActivity);
                                invertedActivitySuperActivityMap.put(newActivity, superActivity);
                                continue;
                            }
                            if (existingSuperActivity == superActivity) continue;
                            this.swallowExistingSuperActivity(superActivities, toBeExpendedMap, invertedActivitySuperActivityMap, superActivity, superActivityId, existingSuperActivity);
                            continue;
                        }
                        if (existingSuperActivity != null) continue;
                        this.createNewSuperActivity(ac, superActivities, toBeExpendedMap, invertedActivitySuperActivityMap, newActivity.getActivityId(), newActivity);
                    }
                }
                if (toBeExpended.size() != 0) continue;
                toBeExpendedMap.remove(superActivityId);
            }
        }
        Map<ConnectorDescriptorId, IConnectorDescriptor> map = ac.getConnectorMap();
        Map<ConnectorDescriptorId, RecordDescriptor> map2 = ac.getConnectorRecordDescriptorMap();
        HashMap<Object, Integer> superActivityProducerPort = new HashMap<Object, Integer>();
        HashMap<Object, Integer> superActivityConsumerPort = new HashMap<Object, Integer>();
        for (Map.Entry entry : superActivities.entrySet()) {
            superActivityProducerPort.put(entry.getValue(), 0);
            superActivityConsumerPort.put(entry.getValue(), 0);
        }
        ActivityCluster newActivityCluster = new ActivityCluster(acg, ac.getId());
        newActivityCluster.setConnectorPolicyAssignmentPolicy(ac.getConnectorPolicyAssignmentPolicy());
        for (Map.Entry entry : superActivities.entrySet()) {
            newActivityCluster.addActivity((IActivity)entry.getValue());
            acg.getActivityMap().put((ActivityId)entry.getKey(), newActivityCluster);
        }
        for (Map.Entry<Object, Object> entry : connectorActivityMap.entrySet()) {
            ConnectorDescriptorId connectorId = (ConnectorDescriptorId)entry.getKey();
            Pair endPoints = (Pair)entry.getValue();
            IActivity producerActivity = (IActivity)((Pair)endPoints.getLeft()).getLeft();
            IActivity consumerActivity = (IActivity)((Pair)endPoints.getRight()).getLeft();
            int producerPort = (Integer)((Pair)endPoints.getLeft()).getRight();
            int consumerPort = (Integer)((Pair)endPoints.getRight()).getRight();
            RecordDescriptor recordDescriptor = map2.get(connectorId);
            IConnectorDescriptor conn = map.get(connectorId);
            if (conn.getClass().getName().contains(ONE_TO_ONE_CONNECTOR)) {
                SuperActivity residingSuperActivity = invertedActivitySuperActivityMap.get(producerActivity);
                residingSuperActivity.connect(conn, producerActivity, producerPort, consumerActivity, consumerPort, recordDescriptor);
                continue;
            }
            SuperActivity producerSuperActivity = invertedActivitySuperActivityMap.get(producerActivity);
            SuperActivity consumerSuperActivity = invertedActivitySuperActivityMap.get(consumerActivity);
            int producerSAPort = (Integer)superActivityProducerPort.get(producerSuperActivity);
            int consumerSAPort = (Integer)superActivityConsumerPort.get(consumerSuperActivity);
            newActivityCluster.addConnector(conn);
            newActivityCluster.connect(conn, producerSuperActivity, producerSAPort, consumerSuperActivity, consumerSAPort, recordDescriptor);
            producerSuperActivity.setClusterOutputIndex(producerSAPort, producerActivity.getActivityId(), producerPort);
            consumerSuperActivity.setClusterInputIndex(consumerSAPort, consumerActivity.getActivityId(), consumerPort);
            acg.getConnectorMap().put(connectorId, newActivityCluster);
            superActivityProducerPort.put(producerSuperActivity, ++producerSAPort);
            superActivityConsumerPort.put(consumerSuperActivity, ++consumerSAPort);
        }
        for (Map.Entry<Object, Object> entry : superActivities.entrySet()) {
            List<IConnectorDescriptor> connIds = newActivityCluster.getActivityOutputMap().get(entry.getKey());
            if (connIds != null && !connIds.isEmpty()) continue;
            newActivityCluster.addRoot((IActivity)entry.getValue());
        }
        newActivityCluster.getBlocked2BlockerMap().putAll(ac.getBlocked2BlockerMap());
        acg.getActivityClusterMap().put(ac.getId(), newActivityCluster);
    }

    private void createNewSuperActivity(ActivityCluster acg, Map<ActivityId, SuperActivity> superActivities, Map<ActivityId, Queue<IActivity>> toBeExpendedMap, Map<IActivity, SuperActivity> invertedActivitySuperActivityMap, ActivityId activityId, IActivity activity) {
        SuperActivity superActivity = new SuperActivity(acg.getActivityClusterGraph(), acg.getId(), activityId);
        superActivities.put(activityId, superActivity);
        superActivity.addActivity(activity);
        LinkedList<IActivity> toBeExpended = new LinkedList<IActivity>();
        toBeExpended.add(activity);
        toBeExpendedMap.put(activityId, toBeExpended);
        invertedActivitySuperActivityMap.put(activity, superActivity);
    }

    private void swallowExistingSuperActivity(Map<ActivityId, SuperActivity> superActivities, Map<ActivityId, Queue<IActivity>> toBeExpendedMap, Map<IActivity, SuperActivity> invertedActivitySuperActivityMap, SuperActivity superActivity, ActivityId superActivityId, SuperActivity existingSuperActivity) {
        ActivityId existingSuperActivityId = existingSuperActivity.getActivityId();
        superActivities.remove(existingSuperActivityId);
        for (Map.Entry<ActivityId, IActivity> existingEntry : existingSuperActivity.getActivityMap().entrySet()) {
            IActivity existingActivity = existingEntry.getValue();
            superActivity.addActivity(existingActivity);
            invertedActivitySuperActivityMap.put(existingActivity, superActivity);
        }
        Queue<IActivity> tbeQueue = toBeExpendedMap.get(superActivityId);
        Queue<IActivity> existingTbeQueque = toBeExpendedMap.remove(existingSuperActivityId);
        if (existingTbeQueque != null) {
            tbeQueue.addAll(existingTbeQueque);
        }
    }
}

