/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.partitions;

import java.io.Serializable;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.job.JobId;

public final class ResultSetPartitionId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JobId jobId;
    private final ResultSetId resultSetId;
    private final int partition;

    public ResultSetPartitionId(JobId jobId, ResultSetId resultSetId, int partition) {
        this.jobId = jobId;
        this.resultSetId = resultSetId;
        this.partition = partition;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public ResultSetId getResultSetId() {
        return this.resultSetId;
    }

    public int getPartition() {
        return this.partition;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resultSetId == null ? 0 : this.resultSetId.hashCode());
        result = 31 * result + (this.jobId == null ? 0 : this.jobId.hashCode());
        result = 31 * result + this.partition;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResultSetPartitionId other = (ResultSetPartitionId)obj;
        if (this.resultSetId == null ? other.resultSetId != null : !this.resultSetId.equals(other.resultSetId)) {
            return false;
        }
        if (this.jobId == null ? other.jobId != null : !this.jobId.equals(other.jobId)) {
            return false;
        }
        return this.partition == other.partition;
    }

    public String toString() {
        return this.jobId.toString() + ":" + this.resultSetId + ":" + this.partition;
    }
}

