/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.exceptions;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksException;

public class HyracksDataException
extends HyracksException {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(HyracksDataException.class.getName());

    public static HyracksDataException create(Throwable cause) {
        if (cause instanceof HyracksDataException || cause == null) {
            return (HyracksDataException)cause;
        }
        if (cause instanceof InterruptedException && !Thread.currentThread().isInterrupted()) {
            LOGGER.log(Level.WARNING, "Wrapping an InterruptedException in HyracksDataException and current thread is not interrupted", cause);
        }
        return new HyracksDataException(cause);
    }

    public static HyracksDataException create(int code, Serializable ... params) {
        return new HyracksDataException("HYR", code, ErrorCode.getErrorMessage(code), params);
    }

    public static HyracksDataException create(int code, Throwable cause, Serializable ... params) {
        return new HyracksDataException("HYR", code, ErrorCode.getErrorMessage(code), cause, params);
    }

    public static HyracksDataException suppress(HyracksDataException root, Throwable th) {
        if (root == null) {
            return HyracksDataException.create(th);
        }
        root.addSuppressed(th);
        return root;
    }

    public HyracksDataException(String component, int errorCode, String message, Throwable cause, String nodeId, Serializable ... params) {
        super(component, errorCode, message, cause, nodeId, params);
    }

    @Deprecated
    public HyracksDataException(String message) {
        super(message);
    }

    @Deprecated
    public HyracksDataException(Throwable cause) {
        super(cause);
    }

    @Deprecated
    public HyracksDataException(Throwable cause, String nodeId) {
        super(cause, nodeId);
    }

    @Deprecated
    public HyracksDataException(String message, Throwable cause, String nodeId) {
        super(message, cause, nodeId);
    }

    @Deprecated
    public HyracksDataException(String message, Throwable cause) {
        super(message, cause);
    }

    public HyracksDataException(String component, int errorCode, Serializable ... params) {
        super(component, errorCode, (String)null, (Throwable)null, (String)null, params);
    }

    public HyracksDataException(Throwable cause, int errorCode, Serializable ... params) {
        super("", errorCode, cause.getMessage(), cause, (String)null, params);
    }

    public HyracksDataException(String component, int errorCode, String message, Serializable ... params) {
        super(component, errorCode, message, (Throwable)null, (String)null, params);
    }

    public HyracksDataException(String component, int errorCode, Throwable cause, Serializable ... params) {
        super(component, errorCode, cause, params);
    }

    public HyracksDataException(String component, int errorCode, String message, Throwable cause, Serializable ... params) {
        super(component, errorCode, message, cause, (String)null, params);
    }

    public static HyracksDataException create(HyracksDataException e, String nodeId) {
        return new HyracksDataException(e.getComponent(), e.getErrorCode(), e.getMessage(), e.getCause(), nodeId, new Serializable[]{e.getParams()});
    }
}

