/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.app.nc.NCAppRuntimeContext;
import org.apache.asterix.app.replication.message.StartupTaskRequestMessage;
import org.apache.asterix.common.api.AsterixThreadFactory;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.config.AsterixExtension;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.config.MessagingProperties;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.config.NodeProperties;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.config.TransactionProperties;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.common.utils.PrintUtil;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.hyracks.bootstrap.ApplicationConfigurator;
import org.apache.asterix.messaging.MessagingChannelInterfaceFactory;
import org.apache.asterix.messaging.NCMessageBroker;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.client.ClusterControllerInfo;
import org.apache.hyracks.api.client.HyracksConnection;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.comm.IChannelInterfaceFactory;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IFileDeviceResolver;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.job.resource.NodeCapacity;
import org.apache.hyracks.api.messages.IMessageBroker;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.nc.BaseNCApplication;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.http.server.WebManager;

public class NCApplication
extends BaseNCApplication {
    private static final Logger LOGGER = Logger.getLogger(NCApplication.class.getName());
    protected INCServiceContext ncServiceCtx;
    private INcApplicationContext runtimeContext;
    private String nodeId;
    private boolean stopInitiated;
    private boolean startupCompleted;
    private IRecoveryManager.SystemState systemState;
    protected WebManager webManager;

    public void registerConfig(IConfigManager configManager) {
        super.registerConfig(configManager);
        ApplicationConfigurator.registerConfigOptions(configManager);
    }

    public void start(IServiceContext serviceCtx, String[] args) throws Exception {
        if (args.length > 0) {
            throw new IllegalArgumentException("Unrecognized argument(s): " + Arrays.toString(args));
        }
        this.ncServiceCtx = (INCServiceContext)serviceCtx;
        this.ncServiceCtx.setThreadFactory((ThreadFactory)new AsterixThreadFactory(this.ncServiceCtx.getThreadFactory(), this.ncServiceCtx.getLifeCycleComponentManager()));
        this.nodeId = this.ncServiceCtx.getNodeId();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Starting Asterix node controller: " + this.nodeId);
        }
        this.configureLoggingLevel(this.ncServiceCtx.getAppConfig().getLoggingLevel((IOption)ExternalProperties.Option.LOG_LEVEL));
        NodeControllerService controllerService = (NodeControllerService)this.ncServiceCtx.getControllerService();
        if (System.getProperty("java.rmi.server.hostname") == null) {
            System.setProperty("java.rmi.server.hostname", controllerService.getConfiguration().getClusterPublicAddress());
        }
        this.runtimeContext = new NCAppRuntimeContext(this.ncServiceCtx, this.getExtensions());
        MetadataProperties metadataProperties = this.runtimeContext.getMetadataProperties();
        if (!metadataProperties.getNodeNames().contains(this.ncServiceCtx.getNodeId())) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Substitute node joining : " + this.ncServiceCtx.getNodeId());
            }
            this.updateOnNodeJoin();
        }
        this.runtimeContext.initialize(this.runtimeContext.getNodeProperties().isInitialRun());
        MessagingProperties messagingProperties = this.runtimeContext.getMessagingProperties();
        NCMessageBroker messageBroker = new NCMessageBroker(controllerService, messagingProperties);
        this.ncServiceCtx.setMessageBroker((IMessageBroker)messageBroker);
        MessagingChannelInterfaceFactory interfaceFactory = new MessagingChannelInterfaceFactory(messageBroker, messagingProperties);
        this.ncServiceCtx.setMessagingChannelInterfaceFactory((IChannelInterfaceFactory)interfaceFactory);
        IRecoveryManager recoveryMgr = this.runtimeContext.getTransactionSubsystem().getRecoveryManager();
        this.systemState = recoveryMgr.getSystemState();
        if (this.systemState == IRecoveryManager.SystemState.PERMANENT_DATA_LOSS) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("System state: " + IRecoveryManager.SystemState.PERMANENT_DATA_LOSS);
                LOGGER.info("Node ID: " + this.nodeId);
                LOGGER.info("Stores: " + PrintUtil.toString((Map)metadataProperties.getStores()));
                LOGGER.info("Root Metadata Store: " + ((String[])metadataProperties.getStores().get(this.nodeId))[0]);
            }
            PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)this.runtimeContext.getLocalResourceRepository();
            localResourceRepository.initializeNewUniverse(ClusterProperties.INSTANCE.getStorageDirectoryName());
        }
        this.webManager = new WebManager();
        this.performLocalCleanUp();
    }

    protected void configureLoggingLevel(Level level) {
        super.configureLoggingLevel(level);
        Logger.getLogger("org.apache.asterix").setLevel(level);
    }

    protected void configureServers() throws Exception {
    }

    protected List<AsterixExtension> getExtensions() {
        return Collections.emptyList();
    }

    public void stop() throws Exception {
        if (!this.stopInitiated) {
            this.runtimeContext.setShuttingdown(true);
            this.stopInitiated = true;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Stopping Asterix node controller: " + this.nodeId);
            }
            this.webManager.stop();
            this.performLocalCleanUp();
            this.ncServiceCtx.getLifeCycleComponentManager().stopAll(false);
            this.runtimeContext.deinitialize();
        } else if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Duplicate attempt to stop ignored: " + this.nodeId);
        }
    }

    public void preStop() throws Exception {
        this.runtimeContext.preStop();
    }

    public void startupCompleted() throws Exception {
        this.configureServers();
        this.webManager.start();
        NodeProperties nodeProperties = this.runtimeContext.getNodeProperties();
        if (this.systemState == IRecoveryManager.SystemState.PERMANENT_DATA_LOSS && (nodeProperties.isInitialRun() || nodeProperties.isVirtualNc())) {
            this.systemState = IRecoveryManager.SystemState.BOOTSTRAPPING;
        }
        StartupTaskRequestMessage.send((NodeControllerService)this.ncServiceCtx.getControllerService(), this.systemState);
        this.startupCompleted = true;
    }

    public void onRegisterNode() throws Exception {
        if (this.startupCompleted) {
            StartupTaskRequestMessage.send((NodeControllerService)this.ncServiceCtx.getControllerService(), this.systemState);
        }
    }

    public NodeCapacity getCapacity() {
        StorageProperties storageProperties = this.runtimeContext.getStorageProperties();
        long memorySize = Runtime.getRuntime().maxMemory() - storageProperties.getBufferCacheSize() - storageProperties.getMemoryComponentGlobalBudget();
        int allCores = Runtime.getRuntime().availableProcessors();
        int maximumCoresForComputation = allCores > 1 ? allCores - 1 : allCores;
        return new NodeCapacity(memorySize, maximumCoresForComputation);
    }

    private void performLocalCleanUp() throws HyracksDataException {
        String[] ioDevices;
        this.runtimeContext.getIoManager().deleteWorkspaceFiles();
        String storageDirName = ClusterProperties.INSTANCE.getStorageDirectoryName();
        for (String ioDevice : ioDevices = ((PersistentLocalResourceRepository)this.runtimeContext.getLocalResourceRepository()).getStorageMountingPoints()) {
            String tempDatasetsDir = ioDevice + storageDirName + File.separator + "temp";
            File tmpDsDir = new File(tempDatasetsDir);
            if (!tmpDsDir.exists()) continue;
            IoUtil.delete((File)tmpDsDir);
        }
    }

    private void updateOnNodeJoin() {
        MetadataProperties metadataProperties = this.runtimeContext.getMetadataProperties();
        if (!metadataProperties.getNodeNames().contains(this.nodeId)) {
            Cluster cluster = ClusterProperties.INSTANCE.getCluster();
            if (cluster == null) {
                throw new IllegalStateException("No cluster configuration found for this instance");
            }
            NCConfig ncConfig = ((NodeControllerService)this.ncServiceCtx.getControllerService()).getConfiguration();
            ncConfig.getConfigManager().ensureNode(this.nodeId);
            String asterixInstanceName = metadataProperties.getInstanceName();
            TransactionProperties txnProperties = this.runtimeContext.getTransactionProperties();
            Node self = null;
            if (cluster.getSubstituteNodes() == null) {
                throw new IllegalStateException("Unknown node joining the cluster");
            }
            List nodes = cluster.getSubstituteNodes().getNode();
            for (Node node : nodes) {
                String ncId = asterixInstanceName + "_" + node.getId();
                if (!ncId.equalsIgnoreCase(this.nodeId)) continue;
                String storeDir = ClusterProperties.INSTANCE.getStorageDirectoryName();
                String nodeIoDevices = node.getIodevices() == null ? cluster.getIodevices() : node.getIodevices();
                String[] ioDevicePaths = nodeIoDevices.trim().split(",");
                int i = 0;
                while (i < ioDevicePaths.length) {
                    int n = i++;
                    ioDevicePaths[n] = ioDevicePaths[n] + File.separator + storeDir;
                }
                metadataProperties.getStores().put(this.nodeId, ioDevicePaths);
                String coredumpPath = node.getLogDir() == null ? cluster.getLogDir() : node.getLogDir();
                metadataProperties.getCoredumpPaths().put(this.nodeId, coredumpPath);
                String txnLogDir = node.getTxnLogDir() == null ? cluster.getTxnLogDir() : node.getTxnLogDir();
                txnProperties.getLogDirectories().put(this.nodeId, txnLogDir);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Store set to : " + storeDir);
                    LOGGER.info("Coredump dir set to : " + coredumpPath);
                    LOGGER.info("Transaction log dir set to :" + txnLogDir);
                }
                self = node;
                break;
            }
            if (self != null) {
                cluster.getSubstituteNodes().getNode().remove(self);
                cluster.getNode().add(self);
            } else {
                throw new IllegalStateException("Unknown node joining the cluster");
            }
        }
    }

    public INcApplicationContext getApplicationContext() {
        return this.runtimeContext;
    }

    public IFileDeviceResolver getFileDeviceResolver() {
        return (relPath, devices) -> {
            int ioDeviceIndex = Math.abs(StoragePathUtil.getPartitionNumFromRelativePath((String)relPath) % devices.size());
            return (IODeviceHandle)devices.get(ioDeviceIndex);
        };
    }

    protected IHyracksClientConnection getHcc() throws Exception {
        NodeControllerService ncSrv = (NodeControllerService)this.ncServiceCtx.getControllerService();
        ClusterControllerInfo ccInfo = ncSrv.getNodeParameters().getClusterControllerInfo();
        return new HyracksConnection(ccInfo.getClientNetAddress(), ccInfo.getClientNetPort());
    }
}

