/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.utils.ExternalIndexingOperations;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;

public class GlobalRecoveryManager
implements IGlobalRecoveryManager {
    private static final Logger LOGGER = Logger.getLogger(GlobalRecoveryManager.class.getName());
    protected final IStorageComponentProvider componentProvider;
    protected final ICCServiceContext serviceCtx;
    protected IHyracksClientConnection hcc;
    protected volatile boolean recoveryCompleted;

    public GlobalRecoveryManager(ICCServiceContext serviceCtx, IHyracksClientConnection hcc, IStorageComponentProvider componentProvider) {
        this.serviceCtx = serviceCtx;
        this.hcc = hcc;
        this.componentProvider = componentProvider;
    }

    public Set<IClusterManagementWork> notifyNodeFailure(Collection<String> deadNodeIds) {
        return Collections.emptySet();
    }

    public Set<IClusterManagementWork> notifyNodeJoin(String joinedNodeId) {
        return Collections.emptySet();
    }

    private void executeHyracksJob(JobSpecification spec) throws Exception {
        spec.setMaxReattempts(0);
        JobId jobId = this.hcc.startJob(spec);
        this.hcc.waitForCompletion(jobId);
    }

    public void startGlobalRecovery(ICcApplicationContext appCtx) throws HyracksDataException {
        if (!this.recoveryCompleted) {
            this.recover(appCtx);
        }
    }

    protected void recover(ICcApplicationContext appCtx) throws HyracksDataException {
        LOGGER.info("Starting Global Recovery");
        MetadataTransactionContext mdTxnCtx = null;
        try {
            MetadataManager.INSTANCE.init();
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            for (Dataverse dataverse : MetadataManager.INSTANCE.getDataverses(mdTxnCtx)) {
                mdTxnCtx = this.recoverDataset(appCtx, mdTxnCtx, dataverse);
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Global recovery was not completed successfully: ", e);
            if (mdTxnCtx != null) {
                try {
                    MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
                }
                catch (Exception e1) {
                    LOGGER.log(Level.SEVERE, "Exception in aborting", e1);
                    e1.addSuppressed(e);
                    throw new IllegalStateException(e);
                }
            }
            throw HyracksDataException.create((Throwable)e);
        }
        this.recoveryCompleted = true;
        LOGGER.info("Global Recovery Completed");
    }

    public void notifyStateChange(IClusterManagementWork.ClusterState newState) {
        if (newState != IClusterManagementWork.ClusterState.ACTIVE) {
            this.recoveryCompleted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataTransactionContext recoverDataset(ICcApplicationContext appCtx, MetadataTransactionContext mdTxnCtx, Dataverse dataverse) throws Exception {
        if (!dataverse.getDataverseName().equals("Metadata")) {
            MetadataProvider metadataProvider = new MetadataProvider(appCtx, dataverse);
            try {
                List datasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverse.getDataverseName());
                for (Dataset dataset : datasets) {
                    List files;
                    if (dataset.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) continue;
                    List indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName());
                    ExternalDatasetDetails dsd = (ExternalDatasetDetails)dataset.getDatasetDetails();
                    DatasetConfig.TransactionState datasetState = dsd.getState();
                    if (!indexes.isEmpty()) {
                        if (datasetState == DatasetConfig.TransactionState.BEGIN) {
                            files = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, dataset);
                            for (ExternalFile file : files) {
                                if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.NO_OP) continue;
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                            }
                        }
                        metadataProvider.setMetadataTxnContext(mdTxnCtx);
                        JobSpecification jobSpec = ExternalIndexingOperations.buildAbortOp((Dataset)dataset, (List)indexes, (MetadataProvider)metadataProvider);
                        this.executeHyracksJob(jobSpec);
                        ((ExternalDatasetDetails)dataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.COMMIT);
                        MetadataManager.INSTANCE.updateDataset(mdTxnCtx, dataset);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                        continue;
                    }
                    if (datasetState != DatasetConfig.TransactionState.READY_TO_COMMIT) continue;
                    files = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, dataset);
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    JobSpecification jobSpec = ExternalIndexingOperations.buildRecoverOp((Dataset)dataset, (List)indexes, (MetadataProvider)metadataProvider);
                    this.executeHyracksJob(jobSpec);
                    for (ExternalFile file : files) {
                        if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.ADD_OP) {
                            MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                            file.setPendingOp(DatasetConfig.ExternalFilePendingOp.NO_OP);
                            MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                        } else if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.DROP_OP) {
                            for (ExternalFile originalFile : files) {
                                if (!originalFile.getFileName().equals(file.getFileName())) continue;
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, originalFile);
                                break;
                            }
                        } else if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.APPEND_OP) {
                            for (ExternalFile originalFile : files) {
                                if (!originalFile.getFileName().equals(file.getFileName())) continue;
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, originalFile);
                                originalFile.setSize(file.getSize());
                                MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, originalFile);
                            }
                        }
                        ((ExternalDatasetDetails)dataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.COMMIT);
                        MetadataManager.INSTANCE.updateDataset(mdTxnCtx, dataset);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    }
                }
            }
            finally {
                metadataProvider.getLocks().unlock();
            }
        }
        return mdTxnCtx;
    }

    public boolean isRecoveryCompleted() {
        return this.recoveryCompleted;
    }
}

