/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication.message;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.app.replication.message.TakeoverPartitionsResponseMessage;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.asterix.common.replication.IRemoteRecoveryManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class TakeoverPartitionsRequestMessage
implements INCLifecycleMessage,
INcAddressedMessage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(TakeoverPartitionsRequestMessage.class.getName());
    private final Integer[] partitions;
    private final long requestId;
    private final String nodeId;

    public TakeoverPartitionsRequestMessage(long requestId, String nodeId, Integer[] partitionsToTakeover) {
        this.requestId = requestId;
        this.nodeId = nodeId;
        this.partitions = partitionsToTakeover;
    }

    public Integer[] getPartitions() {
        return this.partitions;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TakeoverPartitionsRequestMessage.class.getSimpleName());
        sb.append(" Request ID: " + this.requestId);
        sb.append(" Node ID: " + this.nodeId);
        sb.append(" Partitions: ");
        for (Integer partitionId : this.partitions) {
            sb.append(partitionId + ",");
        }
        sb.charAt(sb.length() - 1);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(INcApplicationContext appContext) throws HyracksDataException, InterruptedException {
        INCMessageBroker broker = (INCMessageBroker)appContext.getServiceContext().getMessageBroker();
        if (!appContext.isShuttingdown()) {
            HyracksDataException hde = null;
            try {
                IRemoteRecoveryManager remoteRecoeryManager = appContext.getRemoteRecoveryManager();
                remoteRecoeryManager.takeoverPartitons(this.partitions);
            }
            catch (IOException | ACIDException e) {
                LOGGER.log(Level.SEVERE, "Failure taking over partitions", e);
                hde = HyracksDataException.suppress(hde, (Throwable)e);
            }
            finally {
                TakeoverPartitionsResponseMessage reponse = new TakeoverPartitionsResponseMessage(this.requestId, appContext.getTransactionSubsystem().getId(), this.partitions);
                try {
                    broker.sendMessageToCC((ICcAddressedMessage)reponse);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failure taking over partitions", e);
                    hde = HyracksDataException.suppress((HyracksDataException)hde, (Throwable)e);
                }
            }
            if (hde != null) {
                throw hde;
            }
        }
    }

    public INCLifecycleMessage.MessageType getType() {
        return INCLifecycleMessage.MessageType.TAKEOVER_PARTITION_REQUEST;
    }
}

