/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.app.nc.task.BindMetadataNodeTask;
import org.apache.asterix.app.nc.task.CheckpointTask;
import org.apache.asterix.app.nc.task.ExternalLibrarySetupTask;
import org.apache.asterix.app.nc.task.MetadataBootstrapTask;
import org.apache.asterix.app.nc.task.ReportMaxResourceIdTask;
import org.apache.asterix.app.nc.task.StartFailbackTask;
import org.apache.asterix.app.nc.task.StartLifecycleComponentsTask;
import org.apache.asterix.app.nc.task.StartReplicationServiceTask;
import org.apache.asterix.app.replication.NodeFailbackPlan;
import org.apache.asterix.app.replication.message.CompleteFailbackRequestMessage;
import org.apache.asterix.app.replication.message.CompleteFailbackResponseMessage;
import org.apache.asterix.app.replication.message.NCLifecycleTaskReportMessage;
import org.apache.asterix.app.replication.message.PreparePartitionsFailbackRequestMessage;
import org.apache.asterix.app.replication.message.PreparePartitionsFailbackResponseMessage;
import org.apache.asterix.app.replication.message.StartupTaskRequestMessage;
import org.apache.asterix.app.replication.message.StartupTaskResponseMessage;
import org.apache.asterix.app.replication.message.TakeoverMetadataNodeRequestMessage;
import org.apache.asterix.app.replication.message.TakeoverMetadataNodeResponseMessage;
import org.apache.asterix.app.replication.message.TakeoverPartitionsRequestMessage;
import org.apache.asterix.app.replication.message.TakeoverPartitionsResponseMessage;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.api.INCLifecycleTask;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.replication.IFaultToleranceStrategy;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.util.FaultToleranceUtil;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.application.IClusterLifecycleListener;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class AutoFaultToleranceStrategy
implements IFaultToleranceStrategy {
    private static final Logger LOGGER = Logger.getLogger(AutoFaultToleranceStrategy.class.getName());
    private long clusterRequestId = 0L;
    private Set<String> failedNodes = new HashSet<String>();
    private LinkedList<NodeFailbackPlan> pendingProcessingFailbackPlans = new LinkedList();
    private Map<Long, NodeFailbackPlan> planId2FailbackPlanMap = new HashMap<Long, NodeFailbackPlan>();
    private Map<Long, TakeoverPartitionsRequestMessage> pendingTakeoverRequests = new HashMap<Long, TakeoverPartitionsRequestMessage>();
    private String currentMetadataNode;
    private boolean metadataNodeActive = false;
    private IClusterStateManager clusterManager;
    private ICCMessageBroker messageBroker;
    private IReplicationStrategy replicationStrategy;
    private ICCServiceContext serviceCtx;
    private Set<String> pendingStartupCompletionNodes = new HashSet<String>();

    public void notifyNodeJoin(String nodeId) throws HyracksDataException {
        this.pendingStartupCompletionNodes.add(nodeId);
    }

    public void notifyNodeFailure(String nodeId) throws HyracksDataException {
        if (this.failedNodes.contains(nodeId)) {
            this.notifyFailbackPlansNodeFailure(nodeId);
            this.revertFailedFailbackPlanEffects();
            return;
        }
        this.failedNodes.add(nodeId);
        this.clusterManager.updateNodePartitions(nodeId, false);
        if (nodeId.equals(this.currentMetadataNode)) {
            this.metadataNodeActive = false;
            this.clusterManager.updateMetadataNode(nodeId, this.metadataNodeActive);
        }
        this.validateClusterState();
        FaultToleranceUtil.notifyImpactedReplicas(nodeId, IClusterLifecycleListener.ClusterEventType.NODE_FAILURE, this.clusterManager, this.messageBroker, this.replicationStrategy);
        this.notifyFailbackPlansNodeFailure(nodeId);
        this.requestPartitionsTakeover(nodeId);
    }

    private synchronized void notifyFailbackPlansNodeFailure(String nodeId) {
        for (NodeFailbackPlan plan : this.planId2FailbackPlanMap.values()) {
            plan.notifyNodeFailure(nodeId);
        }
    }

    private synchronized void revertFailedFailbackPlanEffects() {
        Iterator<NodeFailbackPlan> iterator = this.planId2FailbackPlanMap.values().iterator();
        while (iterator.hasNext()) {
            NodeFailbackPlan plan = iterator.next();
            if (plan.getState() != NodeFailbackPlan.FailbackPlanState.PENDING_ROLLBACK) continue;
            iterator.remove();
            this.requestPartitionsTakeover(plan.getNodeId());
        }
    }

    private synchronized void requestPartitionsTakeover(String failedNodeId) {
        HashMap<String, List<Integer>> partitionRecoveryPlan = new HashMap<String, List<Integer>>();
        ICcApplicationContext appCtx = (ICcApplicationContext)this.serviceCtx.getApplicationContext();
        ReplicationProperties replicationProperties = appCtx.getReplicationProperties();
        List<ClusterPartition> lostPartitions = this.getNodeAssignedPartitions(failedNodeId);
        if (!lostPartitions.isEmpty()) {
            for (ClusterPartition clusterPartition : lostPartitions) {
                String replica;
                Set partitionReplicas = replicationProperties.getNodeReplicasIds(clusterPartition.getNodeId());
                Iterator iterator = partitionReplicas.iterator();
                while (iterator.hasNext() && !this.addActiveReplica(replica = (String)iterator.next(), clusterPartition, partitionRecoveryPlan)) {
                }
            }
            if (partitionRecoveryPlan.size() == 0) {
                LOGGER.severe("Could not find active replicas for the partitions " + lostPartitions);
                return;
            }
            LOGGER.info("Partitions to recover: " + lostPartitions);
            for (Map.Entry entry : partitionRecoveryPlan.entrySet()) {
                long requestId;
                String replica = (String)entry.getKey();
                Integer[] partitionsToTakeover = ((List)entry.getValue()).toArray(new Integer[((List)entry.getValue()).size()]);
                ++this.clusterRequestId;
                TakeoverPartitionsRequestMessage takeoverRequest = new TakeoverPartitionsRequestMessage(requestId, replica, partitionsToTakeover);
                this.pendingTakeoverRequests.put(requestId, takeoverRequest);
                try {
                    this.messageBroker.sendApplicationMessageToNC((INcAddressedMessage)takeoverRequest, replica);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to send takeover request: " + takeoverRequest, e);
                }
            }
        }
    }

    private boolean addActiveReplica(String replica, ClusterPartition partition, Map<String, List<Integer>> partitionRecoveryPlan) {
        Map activeNcConfiguration = this.clusterManager.getActiveNcConfiguration();
        if (activeNcConfiguration.containsKey(replica) && !this.failedNodes.contains(replica)) {
            if (!partitionRecoveryPlan.containsKey(replica)) {
                ArrayList<Integer> replicaPartitions = new ArrayList<Integer>();
                replicaPartitions.add(partition.getPartitionId());
                partitionRecoveryPlan.put(replica, replicaPartitions);
            } else {
                partitionRecoveryPlan.get(replica).add(partition.getPartitionId());
            }
            return true;
        }
        return false;
    }

    private synchronized void prepareFailbackPlan(String failingBackNodeId) {
        NodeFailbackPlan plan = NodeFailbackPlan.createPlan(failingBackNodeId);
        this.pendingProcessingFailbackPlans.add(plan);
        this.planId2FailbackPlanMap.put(plan.getPlanId(), plan);
        ICcApplicationContext appCtx = (ICcApplicationContext)this.serviceCtx.getApplicationContext();
        ReplicationProperties replicationProperties = appCtx.getReplicationProperties();
        Set nodeReplicas = replicationProperties.getNodeReplicasIds(failingBackNodeId);
        this.clusterManager.getClusterPartitons();
        for (String replicaId : nodeReplicas) {
            ClusterPartition[] nodePartitions;
            for (ClusterPartition partition : nodePartitions = this.clusterManager.getNodePartitions(replicaId)) {
                plan.addParticipant(partition.getActiveNodeId());
                if (!partition.getNodeId().equals(failingBackNodeId)) continue;
                plan.addPartitionToFailback(partition.getPartitionId(), partition.getActiveNodeId());
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Prepared Failback plan: " + plan.toString());
        }
        this.processPendingFailbackPlans();
    }

    private synchronized void processPendingFailbackPlans() {
        IClusterManagementWork.ClusterState state = this.clusterManager.getState();
        if (state == IClusterManagementWork.ClusterState.ACTIVE) {
            while (!this.pendingProcessingFailbackPlans.isEmpty()) {
                NodeFailbackPlan plan = this.pendingProcessingFailbackPlans.pop();
                if (plan.getState() == NodeFailbackPlan.FailbackPlanState.PREPARING) {
                    String failbackNode = plan.getNodeId();
                    for (Integer partitionId : plan.getPartitionsToFailback()) {
                        this.clusterManager.updateClusterPartition(partitionId, failbackNode, false);
                    }
                    ICcApplicationContext appCtx = (ICcApplicationContext)this.serviceCtx.getApplicationContext();
                    String originalMetadataNode = appCtx.getMetadataProperties().getMetadataNodeName();
                    if (originalMetadataNode.equals(failbackNode)) {
                        plan.setNodeToReleaseMetadataManager(this.currentMetadataNode);
                        this.currentMetadataNode = "";
                        this.metadataNodeActive = false;
                        this.clusterManager.updateMetadataNode(this.currentMetadataNode, this.metadataNodeActive);
                    }
                    this.clusterManager.setState(IClusterManagementWork.ClusterState.REBALANCING);
                    this.handleFailbackRequests(plan, this.messageBroker);
                    break;
                }
                if (plan.getState() != NodeFailbackPlan.FailbackPlanState.PENDING_ROLLBACK) continue;
                this.planId2FailbackPlanMap.remove(plan.getPlanId());
            }
        }
    }

    private void handleFailbackRequests(NodeFailbackPlan plan, ICCMessageBroker messageBroker) {
        for (PreparePartitionsFailbackRequestMessage request : plan.getPlanFailbackRequests()) {
            try {
                messageBroker.sendApplicationMessageToNC((INcAddressedMessage)request, request.getNodeID());
                plan.addPendingRequest(request);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to send failback request to: " + request.getNodeID(), e);
                plan.notifyNodeFailure(request.getNodeID());
                this.revertFailedFailbackPlanEffects();
                break;
            }
        }
    }

    public synchronized List<ClusterPartition> getNodeAssignedPartitions(String nodeId) {
        ArrayList<ClusterPartition> nodePartitions = new ArrayList<ClusterPartition>();
        ClusterPartition[] clusterPartitons = this.clusterManager.getClusterPartitons();
        HashMap<Integer, ClusterPartition> clusterPartitionsMap = new HashMap<Integer, ClusterPartition>();
        for (ClusterPartition partition : clusterPartitons) {
            clusterPartitionsMap.put(partition.getPartitionId(), partition);
        }
        for (ClusterPartition partition : clusterPartitons) {
            if (!nodeId.equals(partition.getActiveNodeId())) continue;
            nodePartitions.add(partition);
        }
        ArrayList<Long> failedTakeoverRequests = new ArrayList<Long>();
        for (TakeoverPartitionsRequestMessage request : this.pendingTakeoverRequests.values()) {
            if (!request.getNodeId().equals(nodeId)) continue;
            for (Integer partitionId : request.getPartitions()) {
                nodePartitions.add((ClusterPartition)clusterPartitionsMap.get(partitionId));
            }
            failedTakeoverRequests.add(request.getRequestId());
        }
        for (Long requestId : failedTakeoverRequests) {
            this.pendingTakeoverRequests.remove(requestId);
        }
        return nodePartitions;
    }

    public synchronized void process(TakeoverPartitionsResponseMessage response) throws HyracksDataException {
        for (Integer partitonId : response.getPartitions()) {
            this.clusterManager.updateClusterPartition(partitonId, response.getNodeId(), true);
        }
        this.pendingTakeoverRequests.remove(response.getRequestId());
        this.validateClusterState();
    }

    public synchronized void process(TakeoverMetadataNodeResponseMessage response) throws HyracksDataException {
        this.currentMetadataNode = response.getNodeId();
        this.metadataNodeActive = true;
        this.clusterManager.updateMetadataNode(this.currentMetadataNode, this.metadataNodeActive);
        this.validateClusterState();
    }

    private void validateClusterState() throws HyracksDataException {
        this.clusterManager.refreshState();
        IClusterManagementWork.ClusterState newState = this.clusterManager.getState();
        if (newState == IClusterManagementWork.ClusterState.PENDING) {
            this.requestMetadataNodeTakeover();
        } else if (newState == IClusterManagementWork.ClusterState.ACTIVE) {
            this.processPendingFailbackPlans();
        }
    }

    public synchronized void process(PreparePartitionsFailbackResponseMessage msg) {
        NodeFailbackPlan plan = this.planId2FailbackPlanMap.get(msg.getPlanId());
        plan.markRequestCompleted(msg.getRequestId());
        if (plan.getState() == NodeFailbackPlan.FailbackPlanState.PENDING_COMPLETION) {
            CompleteFailbackRequestMessage request = plan.getCompleteFailbackRequestMessage();
            try {
                this.messageBroker.sendApplicationMessageToNC((INcAddressedMessage)request, request.getNodeId());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to send complete failback request to: " + request.getNodeId(), e);
                this.notifyFailbackPlansNodeFailure(request.getNodeId());
                this.revertFailedFailbackPlanEffects();
            }
        } else if (plan.getState() == NodeFailbackPlan.FailbackPlanState.PENDING_ROLLBACK) {
            this.revertFailedFailbackPlanEffects();
        }
    }

    public synchronized void process(CompleteFailbackResponseMessage response) throws HyracksDataException {
        NodeFailbackPlan plan = this.planId2FailbackPlanMap.remove(response.getPlanId());
        String nodeId = plan.getNodeId();
        this.failedNodes.remove(nodeId);
        FaultToleranceUtil.notifyImpactedReplicas(nodeId, IClusterLifecycleListener.ClusterEventType.NODE_JOIN, this.clusterManager, this.messageBroker, this.replicationStrategy);
        this.clusterManager.updateNodePartitions(nodeId, true);
        this.validateClusterState();
    }

    private synchronized void requestMetadataNodeTakeover() {
        ICcApplicationContext appCtx = (ICcApplicationContext)this.serviceCtx.getApplicationContext();
        ClusterPartition metadataPartiton = appCtx.getMetadataProperties().getMetadataPartition();
        TakeoverMetadataNodeRequestMessage takeoverRequest = new TakeoverMetadataNodeRequestMessage();
        try {
            this.messageBroker.sendApplicationMessageToNC((INcAddressedMessage)takeoverRequest, metadataPartiton.getActiveNodeId());
            MetadataManager.INSTANCE.rebindMetadataNode();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to send metadata node takeover request to: " + metadataPartiton.getActiveNodeId(), e);
        }
    }

    public IFaultToleranceStrategy from(ICCServiceContext serviceCtx, IReplicationStrategy replicationStrategy) {
        AutoFaultToleranceStrategy ft = new AutoFaultToleranceStrategy();
        ft.messageBroker = (ICCMessageBroker)serviceCtx.getMessageBroker();
        ft.replicationStrategy = replicationStrategy;
        ft.serviceCtx = serviceCtx;
        return ft;
    }

    public synchronized void process(INCLifecycleMessage message) throws HyracksDataException {
        switch (message.getType()) {
            case STARTUP_TASK_REQUEST: {
                this.process((StartupTaskRequestMessage)message);
                break;
            }
            case STARTUP_TASK_RESULT: {
                this.process((NCLifecycleTaskReportMessage)message);
                break;
            }
            case TAKEOVER_PARTITION_RESPONSE: {
                this.process((TakeoverPartitionsResponseMessage)message);
                break;
            }
            case TAKEOVER_METADATA_NODE_RESPONSE: {
                this.process((TakeoverMetadataNodeResponseMessage)message);
                break;
            }
            case PREPARE_FAILBACK_RESPONSE: {
                this.process((PreparePartitionsFailbackResponseMessage)message);
                break;
            }
            case COMPLETE_FAILBACK_RESPONSE: {
                this.process((CompleteFailbackResponseMessage)message);
                break;
            }
            default: {
                throw new RuntimeDataException(4003, new Serializable[]{message.getType().name()});
            }
        }
    }

    private synchronized void process(NCLifecycleTaskReportMessage msg) throws HyracksDataException {
        String nodeId = msg.getNodeId();
        this.pendingStartupCompletionNodes.remove(nodeId);
        if (msg.isSuccess()) {
            if (this.failedNodes.contains(nodeId)) {
                this.prepareFailbackPlan(nodeId);
                return;
            }
            if (this.replicationStrategy.isParticipant(nodeId) && this.failedNodes.remove(nodeId)) {
                FaultToleranceUtil.notifyImpactedReplicas(nodeId, IClusterLifecycleListener.ClusterEventType.NODE_JOIN, this.clusterManager, this.messageBroker, this.replicationStrategy);
            }
            this.clusterManager.updateNodePartitions(nodeId, true);
            if (msg.getNodeId().equals(this.currentMetadataNode)) {
                this.clusterManager.updateMetadataNode(this.currentMetadataNode, true);
            }
            this.clusterManager.refreshState();
        } else {
            LOGGER.log(Level.SEVERE, msg.getNodeId() + " failed to complete startup. ", msg.getException());
        }
    }

    public void bindTo(IClusterStateManager clusterManager) {
        this.clusterManager = clusterManager;
        this.currentMetadataNode = clusterManager.getCurrentMetadataNodeId();
    }

    private synchronized void process(StartupTaskRequestMessage msg) throws HyracksDataException {
        String nodeId = msg.getNodeId();
        IRecoveryManager.SystemState state = msg.getState();
        List<INCLifecycleTask> tasks = state == IRecoveryManager.SystemState.BOOTSTRAPPING || state == IRecoveryManager.SystemState.HEALTHY ? this.buildStartupSequence(nodeId) : this.buildFailbackStartupSequence();
        StartupTaskResponseMessage response = new StartupTaskResponseMessage(nodeId, tasks);
        try {
            this.messageBroker.sendApplicationMessageToNC((INcAddressedMessage)response, msg.getNodeId());
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private List<INCLifecycleTask> buildFailbackStartupSequence() {
        ArrayList<INCLifecycleTask> tasks = new ArrayList<INCLifecycleTask>();
        tasks.add(new StartFailbackTask());
        tasks.add(new ReportMaxResourceIdTask());
        tasks.add(new StartLifecycleComponentsTask());
        return tasks;
    }

    private List<INCLifecycleTask> buildStartupSequence(String nodeId) {
        ArrayList<INCLifecycleTask> tasks = new ArrayList<INCLifecycleTask>();
        tasks.add(new StartReplicationServiceTask());
        boolean isMetadataNode = nodeId.equals(this.currentMetadataNode);
        if (isMetadataNode) {
            tasks.add(new MetadataBootstrapTask());
        }
        tasks.add(new ExternalLibrarySetupTask(isMetadataNode));
        tasks.add(new ReportMaxResourceIdTask());
        tasks.add(new CheckpointTask());
        tasks.add(new StartLifecycleComponentsTask());
        if (isMetadataNode) {
            tasks.add(new BindMetadataNodeTask(true));
        }
        return tasks;
    }
}

