/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.active;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveEvent;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventSubscriber;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IRetryPolicy;
import org.apache.asterix.active.IRetryPolicyFactory;
import org.apache.asterix.active.NoRetryPolicyFactory;
import org.apache.asterix.active.message.ActivePartitionMessage;
import org.apache.asterix.active.message.StatsRequestMessage;
import org.apache.asterix.app.active.ActiveNotificationHandler;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.metadata.IDataset;
import org.apache.asterix.common.metadata.LockList;
import org.apache.asterix.external.feed.watch.WaitForStateSubscriber;
import org.apache.asterix.metadata.api.IActiveEntityController;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.MetadataLockUtil;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;

public abstract class ActiveEntityEventsListener
implements IActiveEntityController {
    private static final Logger LOGGER = Logger.getLogger(ActiveEntityEventsListener.class.getName());
    private static final ActiveEvent STATE_CHANGED = new ActiveEvent(null, ActiveEvent.Kind.STATE_CHANGED, null, null);
    private static final EnumSet<ActivityState> TRANSITION_STATES = EnumSet.of(ActivityState.RESUMING, ActivityState.STARTING, ActivityState.STOPPING, ActivityState.RECOVERING);
    protected final IClusterStateManager clusterStateManager;
    protected final ActiveNotificationHandler handler;
    protected final List<IActiveEntityEventSubscriber> subscribers = new ArrayList<IActiveEntityEventSubscriber>();
    protected final IStatementExecutor statementExecutor;
    protected final ICcApplicationContext appCtx;
    protected final MetadataProvider metadataProvider;
    protected final IHyracksClientConnection hcc;
    protected final EntityId entityId;
    private final List<Dataset> datasets;
    protected final ActiveEvent statsUpdatedEvent;
    protected final String runtimeName;
    protected final IRetryPolicyFactory retryPolicyFactory;
    protected volatile ActivityState state;
    private AlgebricksAbsolutePartitionConstraint locations;
    protected ActivityState prevState;
    protected JobId jobId;
    protected long statsTimestamp;
    protected String stats;
    protected boolean isFetchingStats;
    protected int numRegistered;
    protected volatile Future<Void> recoveryTask;
    protected volatile boolean cancelRecovery;
    protected volatile boolean suspended = false;
    protected Exception jobFailure;
    protected Exception resumeFailure;
    protected Exception startFailure;
    protected Exception stopFailure;
    protected Exception recoverFailure;

    public ActiveEntityEventsListener(IStatementExecutor statementExecutor, ICcApplicationContext appCtx, IHyracksClientConnection hcc, EntityId entityId, List<Dataset> datasets, AlgebricksAbsolutePartitionConstraint locations, String runtimeName, IRetryPolicyFactory retryPolicyFactory) throws HyracksDataException {
        this.statementExecutor = statementExecutor;
        this.appCtx = appCtx;
        this.clusterStateManager = appCtx.getClusterStateManager();
        this.metadataProvider = new MetadataProvider(appCtx, null);
        this.metadataProvider.setConfig(new HashMap());
        this.hcc = hcc;
        this.entityId = entityId;
        this.datasets = datasets;
        this.retryPolicyFactory = retryPolicyFactory;
        this.state = ActivityState.STOPPED;
        this.statsTimestamp = -1L;
        this.isFetchingStats = false;
        this.statsUpdatedEvent = new ActiveEvent(null, ActiveEvent.Kind.STATS_UPDATED, entityId, null);
        this.stats = "{\"Stats\":\"N/A\"}";
        this.runtimeName = runtimeName;
        this.locations = locations;
        this.numRegistered = 0;
        this.handler = (ActiveNotificationHandler)this.metadataProvider.getApplicationContext().getActiveNotificationHandler();
        this.handler.registerListener((IActiveEntityEventsListener)this);
    }

    protected synchronized void setState(ActivityState newState) {
        LOGGER.log(Level.FINE, "State is being set to " + newState + " from " + this.state);
        this.prevState = this.state;
        this.state = newState;
        if (newState == ActivityState.SUSPENDED) {
            this.suspended = true;
        }
        this.notifySubscribers(STATE_CHANGED);
    }

    public synchronized void notify(ActiveEvent event) {
        try {
            LOGGER.fine("EventListener is notified.");
            ActiveEvent.Kind eventKind = event.getEventKind();
            switch (eventKind) {
                case JOB_CREATED: {
                    this.jobCreated(event);
                    break;
                }
                case JOB_STARTED: {
                    this.start(event);
                    break;
                }
                case JOB_FINISHED: {
                    this.finish(event);
                    break;
                }
                case PARTITION_EVENT: {
                    this.handle((ActivePartitionMessage)event.getEventObject());
                    break;
                }
                default: {
                    LOGGER.log(Level.FINE, "Unhandled feed event notification: " + event);
                }
            }
            this.notifySubscribers(event);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unhandled Exception", e);
        }
    }

    protected void jobCreated(ActiveEvent event) {
    }

    protected synchronized void handle(ActivePartitionMessage message) {
        if (message.getEvent() == 0) {
            ++this.numRegistered;
            if (this.numRegistered == this.locations.getLocations().length) {
                this.setState(ActivityState.RUNNING);
            }
        } else if (message.getEvent() == 1) {
            --this.numRegistered;
        }
    }

    protected void finish(ActiveEvent event) throws HyracksDataException {
        this.jobId = null;
        Pair status = (Pair)event.getEventObject();
        JobStatus jobStatus = (JobStatus)status.getLeft();
        List exceptions = (List)status.getRight();
        if (jobStatus.equals((Object)JobStatus.FAILURE)) {
            this.jobFailure = exceptions.isEmpty() ? new RuntimeDataException(3102, new Serializable[0]) : (Exception)exceptions.get(0);
            this.setState(ActivityState.TEMPORARILY_FAILED);
            if (this.prevState != ActivityState.SUSPENDING && this.prevState != ActivityState.RECOVERING) {
                this.recover();
            }
        } else {
            this.setState(this.state == ActivityState.SUSPENDING ? ActivityState.SUSPENDED : ActivityState.STOPPED);
        }
    }

    protected void start(ActiveEvent event) {
        this.jobId = event.getJobId();
        this.numRegistered = 0;
    }

    public synchronized void subscribe(IActiveEntityEventSubscriber subscriber) throws HyracksDataException {
        subscriber.subscribed((IActiveEntityEventsListener)this);
        if (!subscriber.isDone()) {
            this.subscribers.add(subscriber);
        }
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public ActivityState getState() {
        return this.state;
    }

    public synchronized boolean isEntityUsingDataset(IDataset dataset) {
        return this.isActive() && this.getDatasets().contains(dataset);
    }

    public synchronized void remove(Dataset dataset) throws HyracksDataException {
        if (this.isActive()) {
            throw new RuntimeDataException(3092, new Serializable[]{this.entityId, this.state});
        }
        this.getDatasets().remove(dataset);
    }

    public synchronized void add(Dataset dataset) throws HyracksDataException {
        if (this.isActive()) {
            throw new RuntimeDataException(3091, new Serializable[]{this.entityId, this.state});
        }
        this.getDatasets().add(dataset);
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public String getStats() {
        return this.stats;
    }

    public long getStatsTimeStamp() {
        return this.statsTimestamp;
    }

    public String formatStats(List<String> responses) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("{\"Stats\": [").append(responses.get(0));
        for (int i = 1; i < responses.size(); ++i) {
            strBuilder.append(", ").append(responses.get(i));
        }
        strBuilder.append("]}");
        return strBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshStats(long timeout) throws HyracksDataException {
        LOGGER.log(Level.FINE, "refreshStats called");
        ActiveEntityEventsListener activeEntityEventsListener = this;
        synchronized (activeEntityEventsListener) {
            if (this.state != ActivityState.RUNNING || this.isFetchingStats) {
                LOGGER.log(Level.FINE, "returning immediately since state = " + this.state + " and fetchingStats = " + this.isFetchingStats);
                return;
            }
            this.isFetchingStats = true;
        }
        ICCMessageBroker messageBroker = (ICCMessageBroker)this.metadataProvider.getApplicationContext().getServiceContext().getMessageBroker();
        long reqId = messageBroker.newRequestId();
        ArrayList<StatsRequestMessage> requests = new ArrayList<StatsRequestMessage>();
        List<String> ncs = Arrays.asList(this.locations.getLocations());
        for (int i = 0; i < ncs.size(); ++i) {
            requests.add(new StatsRequestMessage(1, (Serializable)new ActiveRuntimeId(this.entityId, this.runtimeName, i), reqId));
        }
        try {
            List responses = (List)messageBroker.sendSyncRequestToNCs(reqId, ncs, requests, timeout);
            this.stats = this.formatStats(responses);
            this.statsTimestamp = System.currentTimeMillis();
            this.notifySubscribers(this.statsUpdatedEvent);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
        this.isFetchingStats = false;
    }

    protected synchronized void notifySubscribers(ActiveEvent event) {
        this.notifyAll();
        Iterator<IActiveEntityEventSubscriber> it = this.subscribers.iterator();
        while (it.hasNext()) {
            IActiveEntityEventSubscriber subscriber = it.next();
            if (subscriber.isDone()) {
                it.remove();
                continue;
            }
            try {
                subscriber.notify(event);
            }
            catch (HyracksDataException e) {
                LOGGER.log(Level.WARNING, "Failed to notify subscriber", e);
            }
            if (!subscriber.isDone()) continue;
            it.remove();
        }
    }

    public AlgebricksAbsolutePartitionConstraint getLocations() {
        return this.locations;
    }

    protected synchronized void waitForNonTransitionState() throws InterruptedException {
        while (TRANSITION_STATES.contains(this.state) || this.suspended) {
            this.wait();
        }
    }

    protected synchronized void checkNoFailure() throws HyracksDataException {
        if (this.state == ActivityState.PERMANENTLY_FAILED) {
            throw HyracksDataException.create((Throwable)this.jobFailure);
        }
    }

    public synchronized void recover() throws HyracksDataException {
        LOGGER.log(Level.FINE, "Recover is called on " + this.entityId);
        if (this.recoveryTask != null) {
            LOGGER.log(Level.FINE, "But recovery task for " + this.entityId + " is already there!! throwing an exception");
            throw new RuntimeDataException(3101, new Serializable[0]);
        }
        if (this.retryPolicyFactory == NoRetryPolicyFactory.INSTANCE) {
            LOGGER.log(Level.FINE, "But it has no recovery policy, so it is set to permanent failure");
            this.setState(ActivityState.PERMANENTLY_FAILED);
        } else {
            ExecutorService executor = this.appCtx.getServiceContext().getControllerService().getExecutor();
            IRetryPolicy policy = this.retryPolicyFactory.create((IActiveEntityEventsListener)this);
            this.cancelRecovery = false;
            this.setState(ActivityState.TEMPORARILY_FAILED);
            LOGGER.log(Level.FINE, "Recovery task has been submitted");
            this.recoveryTask = executor.submit(() -> this.doRecover(policy));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doRecover(IRetryPolicy policy) throws AlgebricksException, HyracksDataException, InterruptedException {
        Object object;
        IMetadataLockManager lockManager;
        LOGGER.log(Level.FINE, "Actual Recovery task has started");
        if (this.getState() != ActivityState.TEMPORARILY_FAILED) {
            LOGGER.log(Level.FINE, "but its state is not temp failure and so we're just returning");
            return null;
        }
        LOGGER.log(Level.FINE, "calling the policy");
        while (policy.retry()) {
            ActiveEntityEventsListener activeEntityEventsListener = this;
            synchronized (activeEntityEventsListener) {
                if (this.cancelRecovery) {
                    this.recoveryTask = null;
                    return null;
                }
                while (this.clusterStateManager.getState() != IClusterManagementWork.ClusterState.ACTIVE) {
                    if (this.cancelRecovery) {
                        this.recoveryTask = null;
                        return null;
                    }
                    this.wait();
                }
            }
            this.waitForNonTransitionState();
            lockManager = this.metadataProvider.getApplicationContext().getMetadataLockManager();
            lockManager.acquireActiveEntityWriteLock(this.metadataProvider.getLocks(), this.entityId.getDataverse() + '.' + this.entityId.getEntityName());
            for (Dataset dataset : this.getDatasets()) {
                MetadataLockUtil.modifyDatasetBegin((IMetadataLockManager)lockManager, (LockList)this.metadataProvider.getLocks(), (String)dataset.getDataverseName(), (String)DatasetUtil.getFullyQualifiedName((Dataset)dataset));
            }
            object = this;
            synchronized (object) {
                Dataset dataset;
                try {
                    this.setState(ActivityState.RECOVERING);
                    this.doStart(this.metadataProvider);
                    dataset = null;
                }
                catch (Exception e) {
                    try {
                        LOGGER.log(Level.WARNING, "Attempt to revive " + this.entityId + " failed", e);
                        this.setState(ActivityState.TEMPORARILY_FAILED);
                        this.recoverFailure = e;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.metadataProvider.getLocks().reset();
                    }
                    this.notifyAll();
                    continue;
                }
                this.metadataProvider.getLocks().reset();
                return dataset;
            }
        }
        lockManager = this.metadataProvider.getApplicationContext().getMetadataLockManager();
        try {
            lockManager.acquireActiveEntityWriteLock(this.metadataProvider.getLocks(), this.entityId.getDataverse() + '.' + this.entityId.getEntityName());
            for (Dataset dataset : this.getDatasets()) {
                MetadataLockUtil.modifyDatasetBegin((IMetadataLockManager)lockManager, (LockList)this.metadataProvider.getLocks(), (String)dataset.getDatasetName(), (String)DatasetUtil.getFullyQualifiedName((Dataset)dataset));
            }
            object = this;
            synchronized (object) {
                if (this.state == ActivityState.TEMPORARILY_FAILED) {
                    this.setState(ActivityState.PERMANENTLY_FAILED);
                    this.recoveryTask = null;
                }
                this.notifyAll();
            }
        }
        finally {
            this.metadataProvider.getLocks().reset();
        }
        return null;
    }

    public synchronized void start(MetadataProvider metadataProvider) throws HyracksDataException, InterruptedException {
        this.waitForNonTransitionState();
        if (this.state != ActivityState.PERMANENTLY_FAILED && this.state != ActivityState.STOPPED) {
            throw new RuntimeDataException(3089, new Serializable[]{this.entityId, this.state});
        }
        try {
            this.setState(ActivityState.STARTING);
            this.doStart(metadataProvider);
            this.setRunning(metadataProvider, true);
        }
        catch (Exception e) {
            this.setState(ActivityState.PERMANENTLY_FAILED);
            LOGGER.log(Level.SEVERE, "Failed to start the entity " + this.entityId, e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected abstract void doStart(MetadataProvider var1) throws HyracksDataException, AlgebricksException;

    protected abstract Void doStop(MetadataProvider var1) throws HyracksDataException, AlgebricksException;

    protected abstract Void doSuspend(MetadataProvider var1) throws HyracksDataException, AlgebricksException;

    protected abstract void doResume(MetadataProvider var1) throws HyracksDataException, AlgebricksException;

    protected abstract void setRunning(MetadataProvider var1, boolean var2) throws HyracksDataException, AlgebricksException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(MetadataProvider metadataProvider) throws HyracksDataException, InterruptedException {
        Future<Void> aRecoveryTask = null;
        ActiveEntityEventsListener activeEntityEventsListener = this;
        synchronized (activeEntityEventsListener) {
            this.waitForNonTransitionState();
            if (this.state != ActivityState.RUNNING && this.state != ActivityState.PERMANENTLY_FAILED && this.state != ActivityState.TEMPORARILY_FAILED) {
                throw new RuntimeDataException(3090, new Serializable[]{this.entityId, this.state});
            }
            if (this.state == ActivityState.TEMPORARILY_FAILED || this.state == ActivityState.PERMANENTLY_FAILED) {
                if (this.recoveryTask != null) {
                    aRecoveryTask = this.recoveryTask;
                    this.cancelRecovery = true;
                    this.recoveryTask.cancel(true);
                }
                this.setState(ActivityState.STOPPED);
                try {
                    this.setRunning(metadataProvider, false);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failed to set the entity state as not running " + this.entityId, e);
                    throw HyracksDataException.create((Throwable)e);
                }
            } else if (this.state == ActivityState.RUNNING) {
                this.setState(ActivityState.STOPPING);
                try {
                    this.doStop(metadataProvider);
                    this.setRunning(metadataProvider, false);
                }
                catch (Exception e) {
                    this.setState(ActivityState.PERMANENTLY_FAILED);
                    LOGGER.log(Level.SEVERE, "Failed to stop the entity " + this.entityId, e);
                    throw HyracksDataException.create((Throwable)e);
                }
            } else {
                throw new RuntimeDataException(3090, new Serializable[]{this.entityId, this.state});
            }
        }
        try {
            if (aRecoveryTask != null) {
                aRecoveryTask.get();
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(MetadataProvider metadataProvider) throws HyracksDataException, InterruptedException {
        Future<Void> suspendTask;
        WaitForStateSubscriber subscriber;
        ActiveEntityEventsListener activeEntityEventsListener = this;
        synchronized (activeEntityEventsListener) {
            LOGGER.log(Level.FINE, "suspending entity " + this.entityId);
            LOGGER.log(Level.FINE, "Waiting for ongoing activities");
            this.waitForNonTransitionState();
            LOGGER.log(Level.FINE, "Proceeding with suspension. Current state is " + this.state);
            if (this.state == ActivityState.STOPPED || this.state == ActivityState.PERMANENTLY_FAILED) {
                this.suspended = true;
                return;
            }
            if (this.state == ActivityState.SUSPENDED) {
                throw new RuntimeDataException(3103, new Serializable[]{this.entityId, this.state});
            }
            if (this.state == ActivityState.TEMPORARILY_FAILED) {
                this.suspended = true;
                this.setState(ActivityState.SUSPENDED);
                return;
            }
            this.setState(ActivityState.SUSPENDING);
            subscriber = new WaitForStateSubscriber((IActiveEntityEventsListener)this, EnumSet.of(ActivityState.SUSPENDED, ActivityState.TEMPORARILY_FAILED));
            suspendTask = metadataProvider.getApplicationContext().getServiceContext().getControllerService().getExecutor().submit(() -> this.doSuspend(metadataProvider));
            LOGGER.log(Level.FINE, "Suspension task has been submitted");
        }
        try {
            LOGGER.log(Level.FINE, "Waiting for suspension task to complete");
            suspendTask.get();
            LOGGER.log(Level.FINE, "waiting for state to become SUSPENDED or TEMPORARILY_FAILED");
            subscriber.sync();
        }
        catch (Exception e) {
            ActiveEntityEventsListener activeEntityEventsListener2 = this;
            synchronized (activeEntityEventsListener2) {
                LOGGER.log(Level.SEVERE, "Failure while waiting for " + this.entityId + " to become suspended", e);
                if (this.state == ActivityState.SUSPENDING) {
                    if (this.jobId != null) {
                        this.setState(this.prevState);
                    } else {
                        this.setState(ActivityState.PERMANENTLY_FAILED);
                    }
                }
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume(MetadataProvider metadataProvider) throws HyracksDataException {
        if (this.state == ActivityState.STOPPED || this.state == ActivityState.PERMANENTLY_FAILED) {
            this.suspended = false;
            this.notifyAll();
            return;
        }
        if (this.state != ActivityState.SUSPENDED && this.state != ActivityState.TEMPORARILY_FAILED) {
            throw new RuntimeDataException(3104, new Serializable[]{this.entityId, this.state});
        }
        try {
            if (this.prevState == ActivityState.TEMPORARILY_FAILED) {
                this.setState(ActivityState.TEMPORARILY_FAILED);
                return;
            }
            this.setState(ActivityState.RESUMING);
            WaitForStateSubscriber subscriber = new WaitForStateSubscriber((IActiveEntityEventsListener)this, EnumSet.of(ActivityState.RUNNING, ActivityState.TEMPORARILY_FAILED));
            this.recoveryTask = metadataProvider.getApplicationContext().getServiceContext().getControllerService().getExecutor().submit(() -> this.resumeOrRecover(metadataProvider));
            try {
                subscriber.sync();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failure while attempting to resume " + this.entityId, e);
                throw HyracksDataException.create((Throwable)e);
            }
        }
        finally {
            this.suspended = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void resumeOrRecover(MetadataProvider metadataProvider) throws HyracksDataException, AlgebricksException, InterruptedException {
        try {
            this.doResume(metadataProvider);
            ActiveEntityEventsListener activeEntityEventsListener = this;
            synchronized (activeEntityEventsListener) {
                this.setState(ActivityState.RUNNING);
                this.recoveryTask = null;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "First attempt to resume " + this.entityId + " Failed", e);
            this.setState(ActivityState.TEMPORARILY_FAILED);
            if (this.retryPolicyFactory == NoRetryPolicyFactory.INSTANCE) {
                this.setState(ActivityState.PERMANENTLY_FAILED);
            }
            IRetryPolicy policy = this.retryPolicyFactory.create((IActiveEntityEventsListener)this);
            this.cancelRecovery = false;
            this.doRecover(policy);
        }
        return null;
    }

    public boolean isActive() {
        return this.state != ActivityState.STOPPED && this.state != ActivityState.PERMANENTLY_FAILED;
    }

    public void unregister() throws HyracksDataException {
        this.handler.unregisterListener((IActiveEntityEventsListener)this);
    }

    public void setLocations(AlgebricksAbsolutePartitionConstraint locations) {
        this.locations = locations;
    }

    public Future<Void> getRecoveryTask() {
        return this.recoveryTask;
    }

    public synchronized void cancelRecovery() {
        this.cancelRecovery = true;
        this.notifyAll();
    }

    public Exception getJobFailure() {
        return this.jobFailure;
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    public synchronized void replace(Dataset dataset) {
        if (this.getDatasets().contains(dataset)) {
            this.getDatasets().remove(dataset);
            this.getDatasets().add(dataset);
        }
    }
}

