/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.lang.aql.parser.TokenMgrError;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.dataset.IHyracksDataset;
import org.apache.hyracks.client.dataset.HyracksDataset;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;

public abstract class RestApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = Logger.getLogger(RestApiServlet.class.getName());
    private final ICcApplicationContext appCtx;
    private final ILangCompilationProvider compilationProvider;
    private final IParserFactory parserFactory;
    private final IStatementExecutorFactory statementExecutorFactory;
    private final IStorageComponentProvider componentProvider;

    public RestApiServlet(ConcurrentMap<String, Object> ctx, String[] paths, ICcApplicationContext appCtx, ILangCompilationProvider compilationProvider, IStatementExecutorFactory statementExecutorFactory, IStorageComponentProvider componentProvider) {
        super(ctx, paths);
        this.appCtx = appCtx;
        this.compilationProvider = compilationProvider;
        this.parserFactory = compilationProvider.getParserFactory();
        this.statementExecutorFactory = statementExecutorFactory;
        this.componentProvider = componentProvider;
    }

    static SessionOutput initResponse(IServletRequest request, IServletResponse response) throws IOException {
        HttpUtil.setContentType((IServletResponse)response, (String)"text/plain", (String)"utf-8");
        SessionConfig.OutputFormat format = SessionConfig.OutputFormat.CLEAN_JSON;
        String output = request.getParameter((CharSequence)"output");
        String accept = request.getHeader((CharSequence)"Accept", "");
        if (output != null) {
            if ("CSV".equals(output)) {
                format = SessionConfig.OutputFormat.CSV;
            } else if ("ADM".equals(output)) {
                format = SessionConfig.OutputFormat.ADM;
            }
        } else if (accept.contains("application/x-adm")) {
            format = SessionConfig.OutputFormat.ADM;
        } else if (accept.contains("text/csv")) {
            format = SessionConfig.OutputFormat.CSV;
        }
        if (format == SessionConfig.OutputFormat.CLEAN_JSON && ("true".equals(request.getParameter((CharSequence)"lossless")) || accept.contains("lossless=true"))) {
            format = SessionConfig.OutputFormat.LOSSLESS_JSON;
        }
        SessionOutput.ResultAppender appendHandle = (app, handle) -> app.append((CharSequence)"{ \"").append((CharSequence)"handle").append((CharSequence)"\": \"").append((CharSequence)handle).append((CharSequence)"\" }");
        SessionConfig sessionConfig = new SessionConfig(format);
        boolean wrapperArray = format == SessionConfig.OutputFormat.CLEAN_JSON || format == SessionConfig.OutputFormat.LOSSLESS_JSON;
        String wrapperParam = request.getParameter((CharSequence)"wrapper-array");
        if (wrapperParam != null) {
            wrapperArray = Boolean.valueOf(wrapperParam);
        } else if (accept.contains("wrap-array=true")) {
            wrapperArray = true;
        } else if (accept.contains("wrap-array=false")) {
            wrapperArray = false;
        }
        sessionConfig.set("format-wrapper-array", wrapperArray);
        switch (format) {
            case ADM: {
                HttpUtil.setContentType((IServletResponse)response, (String)"application/x-adm");
                break;
            }
            case CLEAN_JSON: 
            case LOSSLESS_JSON: {
                HttpUtil.setContentType((IServletResponse)response, (String)"application/json");
                break;
            }
            case CSV: {
                if ("present".equals(request.getParameter((CharSequence)"header")) || accept.contains("header=present")) {
                    HttpUtil.setContentType((IServletResponse)response, (String)"text/csv; header=present");
                    sessionConfig.set("format-csv-header", true);
                    break;
                }
                HttpUtil.setContentType((IServletResponse)response, (String)"text/csv; header=absent");
                break;
            }
            default: {
                throw new IOException("Unknown format " + format);
            }
        }
        return new SessionOutput(sessionConfig, response.writer(), null, null, appendHandle, null);
    }

    protected void get(IServletRequest request, IServletResponse response) {
        this.getOrPost(request, response);
    }

    protected void post(IServletRequest request, IServletResponse response) {
        this.getOrPost(request, response);
    }

    private void getOrPost(IServletRequest request, IServletResponse response) {
        try {
            String query = this.query(request);
            response.setHeader((CharSequence)"Access-Control-Allow-Origin", (Object)"*");
            response.setHeader((CharSequence)"Access-Control-Allow-Headers", (Object)"Origin, X-Requested-With, Content-Type, Accept");
            SessionOutput sessionOutput = RestApiServlet.initResponse(request, response);
            IStatementExecutor.ResultDelivery resultDelivery = this.whichResultDelivery(request);
            this.doHandle(response, query, sessionOutput, resultDelivery);
        }
        catch (Exception e) {
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            LOGGER.log(Level.WARNING, "Failure handling request", e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandle(IServletResponse response, String query, SessionOutput sessionOutput, IStatementExecutor.ResultDelivery resultDelivery) throws JsonProcessingException {
        try {
            response.setStatus(HttpResponseStatus.OK);
            IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
            IHyracksDataset hds = (IHyracksDataset)this.ctx.get("org.apache.asterix.HYRACKS_DATASET");
            if (hds == null) {
                ConcurrentMap concurrentMap = this.ctx;
                synchronized (concurrentMap) {
                    hds = (IHyracksDataset)this.ctx.get("org.apache.asterix.HYRACKS_DATASET");
                    if (hds == null) {
                        hds = new HyracksDataset(hcc, this.appCtx.getCompilerProperties().getFrameSize(), 1);
                        this.ctx.put("org.apache.asterix.HYRACKS_DATASET", hds);
                    }
                }
            }
            IParser parser = this.parserFactory.createParser(query);
            List aqlStatements = parser.parse();
            this.validate(aqlStatements);
            MetadataManager.INSTANCE.init();
            IStatementExecutor translator = this.statementExecutorFactory.create(this.appCtx, aqlStatements, sessionOutput, this.compilationProvider, this.componentProvider);
            translator.compileAndExecute(hcc, hds, resultDelivery, null, new IStatementExecutor.Stats());
        }
        catch (org.apache.asterix.aqlplus.parser.TokenMgrError | AsterixException | TokenMgrError pe) {
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, pe.getMessage(), pe);
            String errorMessage = ResultUtil.buildParseExceptionMessage(pe, query);
            ObjectNode errorResp = ResultUtil.getErrorResponse(2, errorMessage, "", ResultUtil.extractFullStackTrace(pe));
            sessionOutput.out().write(new ObjectMapper().writeValueAsString((Object)errorResp));
        }
        catch (Exception e) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, e.getMessage(), e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            ResultUtil.apiErrorHandler(sessionOutput.out(), e);
        }
    }

    private String query(IServletRequest request) {
        if (request.getHttpRequest().method() == HttpMethod.POST) {
            return HttpUtil.getRequestBody((IServletRequest)request);
        }
        return this.getQueryParameter(request);
    }

    private void validate(List<Statement> aqlStatements) throws AsterixException {
        for (Statement st : aqlStatements) {
            if ((st.getCategory() & this.getAllowedCategories()) != 0) continue;
            throw new AsterixException(String.format(this.getErrorMessage(), st.getKind()));
        }
    }

    protected IStatementExecutor.ResultDelivery whichResultDelivery(IServletRequest request) {
        String mode = request.getParameter((CharSequence)"mode");
        if (mode != null) {
            if ("asynchronous".equals(mode) || "async".equals(mode)) {
                return IStatementExecutor.ResultDelivery.ASYNC;
            }
            if ("asynchronous-deferred".equals(mode) || "deferred".equals(mode)) {
                return IStatementExecutor.ResultDelivery.DEFERRED;
            }
        }
        return IStatementExecutor.ResultDelivery.IMMEDIATE;
    }

    protected abstract String getQueryParameter(IServletRequest var1);

    protected abstract byte getAllowedCategories();

    protected abstract String getErrorMessage();
}

