/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.StaticResourceServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class QueryWebInterfaceServlet
extends StaticResourceServlet {
    private static final Logger LOGGER = Logger.getLogger(QueryWebInterfaceServlet.class.getName());
    private ICcApplicationContext appCtx;

    public QueryWebInterfaceServlet(ICcApplicationContext appCtx, ConcurrentMap<String, Object> ctx, String[] paths) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    protected void get(IServletRequest request, IServletResponse response) throws IOException {
        String requestURI = request.getHttpRequest().uri();
        if ("/".equals(requestURI)) {
            HttpUtil.setContentType((IServletResponse)response, (String)"text/html");
            this.deliverResource("/queryui/queryui.html", response);
        } else {
            this.deliverResource(requestURI, response);
        }
    }

    protected void post(IServletRequest request, IServletResponse response) throws IOException {
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (String)"utf-8");
        ExternalProperties externalProperties = this.appCtx.getExternalProperties();
        response.setStatus(HttpResponseStatus.OK);
        ObjectMapper om = new ObjectMapper();
        ObjectNode obj = om.createObjectNode();
        try {
            PrintWriter out = response.writer();
            obj.put("api_port", String.valueOf(externalProperties.getAPIServerPort()));
            out.println(obj.toString());
            return;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failure writing response", e);
            try {
                response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e2) {
                LOGGER.log(Level.SEVERE, "Failure setting response status", e2);
            }
            return;
        }
    }
}

