/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.lang.aql.parser.TokenMgrError;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.IStatementExecutorContext;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.hyracks.util.JSONUtil;

public class QueryServiceServlet
extends AbstractQueryApiServlet {
    private static final Logger LOGGER = Logger.getLogger(QueryServiceServlet.class.getName());
    protected final ILangExtension.Language queryLanguage;
    private final ILangCompilationProvider compilationProvider;
    private final IStatementExecutorFactory statementExecutorFactory;
    private final IStorageComponentProvider componentProvider;
    private final IStatementExecutorContext queryCtx;
    protected final IServiceContext serviceCtx;

    public QueryServiceServlet(ConcurrentMap<String, Object> ctx, String[] paths, IApplicationContext appCtx, ILangExtension.Language queryLanguage, ILangCompilationProvider compilationProvider, IStatementExecutorFactory statementExecutorFactory, IStorageComponentProvider componentProvider) {
        super(appCtx, ctx, paths);
        this.queryLanguage = queryLanguage;
        this.compilationProvider = compilationProvider;
        this.statementExecutorFactory = statementExecutorFactory;
        this.componentProvider = componentProvider;
        this.queryCtx = (IStatementExecutorContext)ctx.get("org.apache.asterix.RUNINNG_QUERIES");
        this.serviceCtx = (IServiceContext)ctx.get("org.apache.asterix.SERVICE_CONTEXT");
    }

    protected void post(IServletRequest request, IServletResponse response) {
        try {
            this.handleRequest(this.getRequestParameters(request), response);
        }
        catch (IOException e) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static String getParameterValue(String content, String attribute) {
        if (content == null || attribute == null) {
            return null;
        }
        int sc = content.indexOf(59);
        if (sc < 0) {
            return null;
        }
        int eq = content.indexOf(61, sc + 1);
        if (eq < 0) {
            return null;
        }
        if (content.substring(sc + 1, eq).trim().equalsIgnoreCase(attribute)) {
            return content.substring(eq + 1).trim().toLowerCase();
        }
        return null;
    }

    private static String toLower(String s) {
        return s != null ? s.toLowerCase() : s;
    }

    private static SessionConfig.OutputFormat getFormat(String format) {
        if (format != null) {
            if (format.startsWith("text/csv")) {
                return SessionConfig.OutputFormat.CSV;
            }
            if (format.equals("application/x-adm")) {
                return SessionConfig.OutputFormat.ADM;
            }
            if (format.startsWith("application/json")) {
                return Boolean.parseBoolean(QueryServiceServlet.getParameterValue(format, Attribute.LOSSLESS.str())) ? SessionConfig.OutputFormat.LOSSLESS_JSON : SessionConfig.OutputFormat.CLEAN_JSON;
            }
        }
        return SessionConfig.OutputFormat.CLEAN_JSON;
    }

    private static SessionOutput createSessionOutput(RequestParameters param, String handleUrl, PrintWriter resultWriter) {
        SessionOutput.ResultDecorator resultPrefix = ResultUtil.createPreResultDecorator();
        SessionOutput.ResultDecorator resultPostfix = ResultUtil.createPostResultDecorator();
        SessionOutput.ResultAppender appendHandle = ResultUtil.createResultHandleAppender(handleUrl);
        SessionOutput.ResultAppender appendStatus = ResultUtil.createResultStatusAppender();
        SessionConfig.OutputFormat format = QueryServiceServlet.getFormat(param.format);
        SessionConfig sessionConfig = new SessionConfig(format);
        sessionConfig.set("format-wrapper-array", true);
        sessionConfig.set("indent-json", param.pretty);
        sessionConfig.set("quote-record", format != SessionConfig.OutputFormat.CLEAN_JSON && format != SessionConfig.OutputFormat.LOSSLESS_JSON);
        sessionConfig.set("format-csv-header", format == SessionConfig.OutputFormat.CSV && "present".equals(QueryServiceServlet.getParameterValue(param.format, Attribute.HEADER.str())));
        return new SessionOutput(sessionConfig, resultWriter, resultPrefix, resultPostfix, appendHandle, appendStatus);
    }

    private static void printClientContextID(PrintWriter pw, RequestParameters params) {
        if (params.clientContextID != null && !params.clientContextID.isEmpty()) {
            ResultUtil.printField(pw, AbstractQueryApiServlet.ResultFields.CLIENT_ID.str(), params.clientContextID);
        }
    }

    private static void printSignature(PrintWriter pw) {
        ResultUtil.printField(pw, AbstractQueryApiServlet.ResultFields.SIGNATURE.str(), "*");
    }

    private static void printType(PrintWriter pw, SessionConfig sessionConfig) {
        switch (sessionConfig.fmt()) {
            case ADM: {
                ResultUtil.printField(pw, AbstractQueryApiServlet.ResultFields.TYPE.str(), "application/x-adm");
                break;
            }
            case CSV: {
                String contentType = "text/csv; header=" + (sessionConfig.is("format-csv-header") ? "present" : "absent");
                ResultUtil.printField(pw, AbstractQueryApiServlet.ResultFields.TYPE.str(), contentType);
                break;
            }
        }
    }

    private static void printMetrics(PrintWriter pw, long elapsedTime, long executionTime, long resultCount, long resultSize, long errorCount) {
        boolean hasErrors = errorCount != 0L;
        pw.print("\t\"");
        pw.print(AbstractQueryApiServlet.ResultFields.METRICS.str());
        pw.print("\": {\n");
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.ELAPSED_TIME.str(), TimeUnit.formatNanos(elapsedTime));
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.EXECUTION_TIME.str(), TimeUnit.formatNanos(executionTime));
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.RESULT_COUNT.str(), resultCount, true);
        pw.print("\t");
        ResultUtil.printField(pw, Metrics.RESULT_SIZE.str(), resultSize, hasErrors);
        if (hasErrors) {
            pw.print("\t");
            ResultUtil.printField(pw, Metrics.ERROR_COUNT.str(), errorCount, false);
        }
        pw.print("\t}\n");
    }

    private String getOptText(JsonNode node, String fieldName) {
        JsonNode value = node.get(fieldName);
        return value != null ? value.asText() : null;
    }

    private boolean getOptBoolean(JsonNode node, String fieldName, boolean defaultValue) {
        JsonNode value = node.get(fieldName);
        return value != null ? value.asBoolean() : defaultValue;
    }

    private RequestParameters getRequestParameters(IServletRequest request) throws IOException {
        String contentType = HttpUtil.getContentTypeOnly((IServletRequest)request);
        RequestParameters param = new RequestParameters();
        param.host = this.host(request);
        param.path = this.servletPath(request);
        if ("application/json".equals(contentType)) {
            try {
                JsonNode jsonRequest = new ObjectMapper().readTree(HttpUtil.getRequestBody((IServletRequest)request));
                param.statement = jsonRequest.get(Parameter.STATEMENT.str()).asText();
                param.format = QueryServiceServlet.toLower(this.getOptText(jsonRequest, Parameter.FORMAT.str()));
                param.pretty = this.getOptBoolean(jsonRequest, Parameter.PRETTY.str(), false);
                param.mode = QueryServiceServlet.toLower(this.getOptText(jsonRequest, Parameter.MODE.str()));
                param.clientContextID = this.getOptText(jsonRequest, Parameter.CLIENT_ID.str());
            }
            catch (JsonParseException | JsonMappingException e) {
                GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            param.statement = request.getParameter((CharSequence)Parameter.STATEMENT.str());
            if (param.statement == null) {
                param.statement = HttpUtil.getRequestBody((IServletRequest)request);
            }
            param.format = QueryServiceServlet.toLower(request.getParameter((CharSequence)Parameter.FORMAT.str()));
            param.pretty = Boolean.parseBoolean(request.getParameter((CharSequence)Parameter.PRETTY.str()));
            param.mode = QueryServiceServlet.toLower(request.getParameter((CharSequence)Parameter.MODE.str()));
            param.clientContextID = request.getParameter((CharSequence)Parameter.CLIENT_ID.str());
        }
        return param;
    }

    private static IStatementExecutor.ResultDelivery parseResultDelivery(String mode) {
        if ("async".equals(mode)) {
            return IStatementExecutor.ResultDelivery.ASYNC;
        }
        if ("deferred".equals(mode)) {
            return IStatementExecutor.ResultDelivery.DEFERRED;
        }
        return IStatementExecutor.ResultDelivery.IMMEDIATE;
    }

    private static String handlePath(IStatementExecutor.ResultDelivery delivery) {
        switch (delivery) {
            case ASYNC: {
                return "/status/";
            }
            case DEFERRED: {
                return "/result/";
            }
        }
        return "";
    }

    protected String getHandleUrl(String host, String path, IStatementExecutor.ResultDelivery delivery) {
        return "http://" + host + path + QueryServiceServlet.handlePath(delivery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(RequestParameters param, IServletResponse response) throws IOException {
        LOGGER.info(param.toString());
        long elapsedStart = System.nanoTime();
        StringWriter stringWriter = new StringWriter();
        PrintWriter resultWriter = new PrintWriter(stringWriter);
        IStatementExecutor.ResultDelivery delivery = QueryServiceServlet.parseResultDelivery(param.mode);
        String handleUrl = this.getHandleUrl(param.host, param.path, delivery);
        SessionOutput sessionOutput = QueryServiceServlet.createSessionOutput(param, handleUrl, resultWriter);
        SessionConfig sessionConfig = sessionOutput.config();
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (String)"utf-8");
        HttpResponseStatus status = HttpResponseStatus.OK;
        IStatementExecutor.Stats stats = new IStatementExecutor.Stats();
        long[] execStartEnd = new long[]{-1L, -1L};
        resultWriter.print("{\n");
        QueryServiceServlet.printRequestId(resultWriter);
        QueryServiceServlet.printClientContextID(resultWriter, param);
        QueryServiceServlet.printSignature(resultWriter);
        QueryServiceServlet.printType(resultWriter, sessionConfig);
        long errorCount = 1L;
        try {
            if (param.statement == null || param.statement.isEmpty()) {
                throw new AsterixException("Empty request, no statement provided");
            }
            String statementsText = param.statement + ";";
            this.executeStatement(statementsText, sessionOutput, delivery, stats, param, handleUrl, execStartEnd);
            if (IStatementExecutor.ResultDelivery.IMMEDIATE == delivery || IStatementExecutor.ResultDelivery.DEFERRED == delivery) {
                ResultUtil.printStatus(sessionOutput, AbstractQueryApiServlet.ResultStatus.SUCCESS);
            }
            errorCount = 0L;
        }
        catch (Exception | org.apache.asterix.aqlplus.parser.TokenMgrError | TokenMgrError e) {
            status = this.handleExecuteStatementException(e);
            ResultUtil.printError(resultWriter, e);
            ResultUtil.printStatus(sessionOutput, AbstractQueryApiServlet.ResultStatus.FATAL);
        }
        finally {
            if (execStartEnd[0] == -1L) {
                execStartEnd[1] = -1L;
            } else if (execStartEnd[1] == -1L) {
                execStartEnd[1] = System.nanoTime();
            }
        }
        QueryServiceServlet.printMetrics(resultWriter, System.nanoTime() - elapsedStart, execStartEnd[1] - execStartEnd[0], stats.getCount(), stats.getSize(), errorCount);
        resultWriter.print("}\n");
        resultWriter.flush();
        String result = stringWriter.toString();
        GlobalConfig.ASTERIX_LOGGER.log(Level.FINE, result);
        response.setStatus(status);
        response.writer().print(result);
        if (response.writer().checkError()) {
            LOGGER.warning("Error flushing output writer");
        }
    }

    protected void executeStatement(String statementsText, SessionOutput sessionOutput, IStatementExecutor.ResultDelivery delivery, IStatementExecutor.Stats stats, RequestParameters param, String handleUrl, long[] outExecStartEnd) throws Exception {
        IClusterManagementWork.ClusterState clusterState = ClusterStateManager.INSTANCE.getState();
        if (clusterState != IClusterManagementWork.ClusterState.ACTIVE) {
            throw new IllegalStateException("Cannot execute request, cluster is " + clusterState);
        }
        IParser parser = this.compilationProvider.getParserFactory().createParser(statementsText);
        List statements = parser.parse();
        MetadataManager.INSTANCE.init();
        IStatementExecutor translator = this.statementExecutorFactory.create((ICcApplicationContext)this.appCtx, statements, sessionOutput, this.compilationProvider, this.componentProvider);
        outExecStartEnd[0] = System.nanoTime();
        translator.compileAndExecute(this.getHyracksClientConnection(), this.getHyracksDataset(), delivery, null, stats, param.clientContextID, this.queryCtx);
        outExecStartEnd[1] = System.nanoTime();
    }

    protected HttpResponseStatus handleExecuteStatementException(Throwable t) {
        if (t instanceof org.apache.asterix.aqlplus.parser.TokenMgrError || t instanceof TokenMgrError || t instanceof AlgebricksException) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.INFO, t.getMessage(), t);
            return HttpResponseStatus.BAD_REQUEST;
        }
        if (t instanceof HyracksException) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.WARNING, t.getMessage(), t);
            return HttpResponseStatus.INTERNAL_SERVER_ERROR;
        }
        GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, "Unexpected exception", t);
        return HttpResponseStatus.INTERNAL_SERVER_ERROR;
    }

    static class RequestParameters {
        String host;
        String path;
        String statement;
        String format;
        boolean pretty;
        String clientContextID;
        String mode;

        RequestParameters() {
        }

        public String toString() {
            try {
                ObjectMapper om = new ObjectMapper();
                ObjectNode on = om.createObjectNode();
                on.put("host", this.host);
                on.put("path", this.path);
                on.put("statement", JSONUtil.escape((StringBuilder)new StringBuilder(), (String)this.statement).toString());
                on.put("pretty", this.pretty);
                on.put("mode", this.mode);
                on.put("clientContextID", this.clientContextID);
                return om.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValueAsString((Object)on);
            }
            catch (JsonProcessingException e) {
                return e.getMessage();
            }
        }
    }

    public static enum TimeUnit {
        SEC("s", 9),
        MILLI("ms", 6),
        MICRO("\u00b5s", 3),
        NANO("ns", 0);

        String unit;
        int nanoDigits;

        private TimeUnit(String unit, int nanoDigits) {
            this.unit = unit;
            this.nanoDigits = nanoDigits;
        }

        public static String formatNanos(long nanoTime) {
            String strTime = String.valueOf(nanoTime);
            int len = strTime.length();
            for (TimeUnit tu : TimeUnit.values()) {
                if (len <= tu.nanoDigits) continue;
                String integer = strTime.substring(0, len - tu.nanoDigits);
                String fractional = strTime.substring(len - tu.nanoDigits);
                return integer + (fractional.length() > 0 ? "." + fractional : "") + tu.unit;
            }
            return "illegal string value: " + strTime;
        }
    }

    private static enum Metrics {
        ELAPSED_TIME("elapsedTime"),
        EXECUTION_TIME("executionTime"),
        RESULT_COUNT("resultCount"),
        RESULT_SIZE("resultSize"),
        ERROR_COUNT("errorCount");

        private final String str;

        private Metrics(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }

    private static enum Attribute {
        HEADER("header"),
        LOSSLESS("lossless");

        private final String str;

        private Attribute(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }

    public static enum Parameter {
        STATEMENT("statement"),
        FORMAT("format"),
        CLIENT_ID("client_context_id"),
        PRETTY("pretty"),
        MODE("mode");

        private final String str;

        private Parameter(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }
}

