/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.api.http.server.NodeControllerDetailsApiServlet;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class DiagnosticsApiServlet
extends NodeControllerDetailsApiServlet {
    private static final Logger LOGGER = Logger.getLogger(DiagnosticsApiServlet.class.getName());
    private final ICcApplicationContext appCtx;

    public DiagnosticsApiServlet(ConcurrentMap<String, Object> ctx, String[] paths, ICcApplicationContext appCtx) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    @Override
    protected void get(IServletRequest request, IServletResponse response) throws IOException {
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (String)"utf-8");
        PrintWriter responseWriter = response.writer();
        ObjectMapper om = new ObjectMapper();
        response.setStatus(HttpResponseStatus.OK);
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            if (!"".equals(this.localPath(request))) {
                throw new IllegalArgumentException();
            }
            ObjectNode json = this.getClusterDiagnosticsJSON();
            responseWriter.write(om.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
        }
        catch (IllegalStateException e) {
            response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
        }
        catch (IllegalArgumentException e) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "exception thrown for " + request, e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            responseWriter.write(e.toString());
        }
        responseWriter.flush();
    }

    private ObjectNode getClusterDiagnosticsJSON() throws Exception {
        ObjectMapper om = new ObjectMapper();
        IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
        ExecutorService executor = (ExecutorService)this.ctx.get("org.apache.asterix.EXECUTOR_SERVICE");
        HashMap<String, Future<ObjectNode>> ccFutureData = new HashMap<String, Future<ObjectNode>>();
        ccFutureData.put("threaddump", executor.submit(() -> this.fixupKeys((ObjectNode)om.readTree(hcc.getThreadDump(null)))));
        ccFutureData.put("config", executor.submit(() -> this.fixupKeys((ObjectNode)om.readTree(hcc.getNodeDetailsJSON(null, false, true)))));
        ccFutureData.put("stats", executor.submit(() -> this.fixupKeys((ObjectNode)om.readTree(hcc.getNodeDetailsJSON(null, true, false)))));
        HashMap ncDataMap = new HashMap();
        for (String nc : this.appCtx.getMetadataProperties().getNodeNames()) {
            HashMap<String, Future<ObjectNode>> ncData = new HashMap<String, Future<ObjectNode>>();
            ncData.put("threaddump", executor.submit(() -> this.fixupKeys((ObjectNode)om.readTree(hcc.getThreadDump(nc)))));
            ncData.put("config", executor.submit(() -> this.fixupKeys((ObjectNode)om.readTree(hcc.getNodeDetailsJSON(nc, false, true)))));
            ncData.put("stats", executor.submit(() -> this.fixupKeys(this.processNodeStats(hcc, nc))));
            ncDataMap.put(nc, ncData);
        }
        ObjectNode result = om.createObjectNode();
        result.putPOJO("cc", this.resolveFutures(ccFutureData));
        ArrayList<Map<String, Object>> ncList = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : ncDataMap.entrySet()) {
            Map<String, Object> ncMap = this.resolveFutures((Map)entry.getValue());
            ncMap.put("node_id", entry.getKey());
            ncList.add(ncMap);
        }
        result.putPOJO("ncs", ncList);
        result.putPOJO("date", (Object)new Date());
        return result;
    }

    private Map<String, Object> resolveFutures(Map<String, Future<ObjectNode>> futureMap) throws ExecutionException, InterruptedException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Future<ObjectNode>> entry : futureMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().get());
        }
        return result;
    }
}

